/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * 
 * @format
 */
// flowlint ambiguous-object-type:error
'use strict';

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

function _createForOfIteratorHelper(o) { if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (o = _unsupportedIterableToArray(o))) { var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var it, normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(n); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var IRTransformer = require('../core/IRTransformer');

var invariant = require("fbjs/lib/invariant");

var joinArgumentDefinitions = require('../util/joinArgumentDefinitions');

var _require = require('../core/CompilerError'),
    createUserError = _require.createUserError;

/**
 * A transform that inlines fragment spreads with the @relay(mask: false)
 * directive.
 */
function maskTransform(context) {
  return IRTransformer.transform(context, {
    FragmentSpread: visitFragmentSpread,
    Fragment: visitFragment
  }, function () {
    return {
      reachableArguments: []
    };
  });
}

function visitFragment(fragment, state) {
  var result = this.traverse(fragment, state);

  if (state.reachableArguments.length === 0) {
    return result;
  }

  var joinedArgumentDefinitions = joinArgumentDefinitions(this.getContext().getSchema(), fragment, state.reachableArguments, '@relay(unmask: true)');
  return _objectSpread({}, result, {
    argumentDefinitions: joinedArgumentDefinitions
  });
}

function visitFragmentSpread(fragmentSpread, state) {
  if (!isUnmaskedSpread(fragmentSpread)) {
    return fragmentSpread;
  }

  !(fragmentSpread.args.length === 0) ? process.env.NODE_ENV !== "production" ? invariant(false, 'MaskTransform: Cannot unmask fragment spread `%s` with ' + 'arguments. Use the `ApplyFragmentArgumentTransform` before flattening', fragmentSpread.name) : invariant(false) : void 0;
  var context = this.getContext();
  var fragment = context.getFragment(fragmentSpread.name);
  var result = {
    kind: 'InlineFragment',
    directives: fragmentSpread.directives,
    loc: {
      kind: 'Derived',
      source: fragmentSpread.loc
    },
    metadata: fragmentSpread.metadata,
    selections: fragment.selections,
    typeCondition: fragment.type
  };

  if (fragment.directives.length > 0) {
    throw new createUserError('Cannot use @relay(mask: false) on fragment spreads for fragments ' + 'with directives.', [fragmentSpread.loc, fragment.directives[0].loc]);
  }

  var localArgDef = fragment.argumentDefinitions.find(function (argDef) {
    return argDef.kind === 'LocalArgumentDefinition';
  });

  if (localArgDef != null) {
    throw createUserError('MaskTransform: Cannot use @relay(mask: false) on fragment spread ' + 'because the fragment definition uses @argumentDefinitions.', [fragmentSpread.loc, localArgDef.loc]);
  } // Note: defer validating arguments to the containing fragment in order
  // to list all invalid variables/arguments instead of only one.


  var _iterator = _createForOfIteratorHelper(fragment.argumentDefinitions),
      _step;

  try {
    for (_iterator.s(); !(_step = _iterator.n()).done;) {
      var argDef = _step.value;
      state.reachableArguments.push(argDef);
    }
  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }

  return this.traverse(result, state);
}
/**
 * @private
 */


function isUnmaskedSpread(spread) {
  return Boolean(spread.metadata && spread.metadata.mask === false);
}

module.exports = {
  transform: maskTransform
};