"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConfigSet = exports.TS_JEST_OUT_DIR = exports.IGNORE_DIAGNOSTIC_CODES = exports.MATCH_NOTHING = void 0;
var bs_logger_1 = require("bs-logger");
var fs_1 = require("fs");
var jest_util_1 = require("jest-util");
var json5 = require("json5");
var path_1 = require("path");
var typescript_1 = require("typescript");
var __1 = require("..");
var instance_1 = require("../compiler/instance");
var constants_1 = require("../constants");
var transformers_1 = require("../transformers");
var backports_1 = require("../util/backports");
var get_package_version_1 = require("../util/get-package-version");
var importer_1 = require("../util/importer");
var json_1 = require("../util/json");
var jsonable_value_1 = require("../util/jsonable-value");
var logger_1 = require("../util/logger");
var memoize_1 = require("../util/memoize");
var messages_1 = require("../util/messages");
var normalize_slashes_1 = require("../util/normalize-slashes");
var sha1_1 = require("../util/sha1");
var ts_error_1 = require("../util/ts-error");
var logger = logger_1.rootLogger.child({ namespace: 'config' });
/**
 * @internal
 */
// this regex MUST match nothing, it's the goal ;-)
exports.MATCH_NOTHING = /a^/;
/**
 * @internal
 */
exports.IGNORE_DIAGNOSTIC_CODES = [
    6059,
    18002,
    18003,
];
/**
 * @internal
 */
exports.TS_JEST_OUT_DIR = '$$ts-jest$$';
var TARGET_TO_VERSION_MAPPING = (_a = {},
    _a[typescript_1.ScriptTarget.ES2018] = 'es2018',
    _a[typescript_1.ScriptTarget.ES2019] = 'es2019',
    _a[typescript_1.ScriptTarget.ES2020] = 'es2020',
    _a[typescript_1.ScriptTarget.ESNext] = 'ESNext',
    _a);
var normalizeRegex = function (pattern) {
    return pattern ? (typeof pattern === 'string' ? pattern : pattern.source) : undefined;
};
var toDiagnosticCode = function (code) {
    // eslint-disable-next-line @typescript-eslint/restrict-template-expressions
    return code ? parseInt(("" + code).trim().replace(/^TS/, ''), 10) || undefined : undefined;
};
var toDiagnosticCodeList = function (items, into) {
    var e_1, _a;
    if (into === void 0) { into = []; }
    if (!Array.isArray(items))
        items = [items];
    try {
        for (var items_1 = __values(items), items_1_1 = items_1.next(); !items_1_1.done; items_1_1 = items_1.next()) {
            var item = items_1_1.value;
            if (!item)
                continue;
            if (Array.isArray(item)) {
                toDiagnosticCodeList(item, into);
                continue;
            }
            else if (typeof item === 'string') {
                var children = item.trim().split(/\s*,\s*/g);
                if (children.length > 1) {
                    toDiagnosticCodeList(children, into);
                    continue;
                }
                item = children[0];
            }
            if (!item)
                continue;
            var code = toDiagnosticCode(item);
            if (code && !into.includes(code))
                into.push(code);
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (items_1_1 && !items_1_1.done && (_a = items_1.return)) _a.call(items_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
    return into;
};
var ConfigSet = /** @class */ (function () {
    function ConfigSet(jestConfig, parentOptions, parentLogger) {
        var _a;
        this.parentOptions = parentOptions;
        this._jestConfig = jestConfig;
        this.logger = parentLogger ? parentLogger.child((_a = {}, _a[bs_logger_1.LogContexts.namespace] = 'config', _a)) : logger;
    }
    Object.defineProperty(ConfigSet.prototype, "jest", {
        /**
         * @internal
         */
        get: function () {
            var _a;
            var config = backports_1.backportJestConfig(this.logger, this._jestConfig);
            if (this.parentOptions) {
                var globals = (_a = config.globals) !== null && _a !== void 0 ? _a : Object.create(null);
                globals['ts-jest'] = __assign(__assign({}, this.parentOptions), globals['ts-jest']);
            }
            this.logger.debug({ jestConfig: config }, 'normalized jest config');
            return config;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ConfigSet.prototype, "isTestFile", {
        /**
         * @internal
         */
        get: function () {
            var matchablePatterns = __spread(this.jest.testMatch, this.jest.testRegex).filter(function (pattern) {
                /**
                 * jest config testRegex doesn't always deliver the correct RegExp object
                 * See https://github.com/facebook/jest/issues/9778
                 */
                return pattern instanceof RegExp || typeof pattern === 'string';
            });
            if (!matchablePatterns.length) {
                matchablePatterns.push.apply(matchablePatterns, __spread(constants_1.DEFAULT_JEST_TEST_MATCH));
            }
            var stringPatterns = matchablePatterns.filter(function (pattern) { return typeof pattern === 'string'; });
            var isMatch = jest_util_1.globsToMatcher(stringPatterns);
            return function (fileName) {
                return matchablePatterns.some(function (pattern) { return (typeof pattern === 'string' ? isMatch(fileName) : pattern.test(fileName)); });
            };
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ConfigSet.prototype, "tsJest", {
        /**
         * @internal
         */
        get: function () {
            var _this = this;
            var _a, _b, _c;
            var parsedConfig = this.jest;
            var _d = parsedConfig.globals, globals = _d === void 0 ? {} : _d;
            var options = __assign({}, globals['ts-jest']);
            // tsconfig
            var tsConfigOpt = (_b = (_a = options.tsConfig) !== null && _a !== void 0 ? _a : options.tsconfig) !== null && _b !== void 0 ? _b : true;
            var tsConfig;
            if (typeof tsConfigOpt === 'string' || tsConfigOpt === true) {
                tsConfig = {
                    kind: 'file',
                    value: typeof tsConfigOpt === 'string' ? this.resolvePath(tsConfigOpt) : undefined,
                };
            }
            else if (typeof tsConfigOpt === 'object') {
                tsConfig = {
                    kind: 'inline',
                    value: tsConfigOpt,
                };
            }
            // packageJson
            var packageJsonOpt = options.packageJson;
            var packageJson;
            if (typeof packageJsonOpt === 'string' || packageJsonOpt == null || packageJsonOpt === true) {
                packageJson = {
                    kind: 'file',
                    value: typeof packageJsonOpt === 'string' ? this.resolvePath(packageJsonOpt) : undefined,
                };
            }
            else if (typeof packageJsonOpt === 'object') {
                packageJson = {
                    kind: 'inline',
                    value: packageJsonOpt,
                };
            }
            // transformers
            var transformers = Object.create(null);
            var astTransformers = options.astTransformers;
            if (astTransformers) {
                if (Array.isArray(astTransformers)) {
                    this.logger.warn("The configuration for astTransformers as string[] is deprecated and will be removed in ts-jest 27. Please define your custom AST transformers in a form of an object. More information you can check online documentation https://kulshekhar.github.io/ts-jest/user/config/astTransformers" /* AstTransformerArrayConfig */);
                    transformers = {
                        before: astTransformers.map(function (transformerPath) { return _this.resolvePath(transformerPath, { nodeResolve: true }); }),
                    };
                }
                else {
                    if (astTransformers.before) {
                        transformers = {
                            before: astTransformers.before.map(function (transformerPath) {
                                return _this.resolvePath(transformerPath, { nodeResolve: true });
                            }),
                        };
                    }
                    if (astTransformers.after) {
                        transformers = __assign(__assign({}, transformers), { after: astTransformers.after.map(function (transformerPath) {
                                return _this.resolvePath(transformerPath, { nodeResolve: true });
                            }) });
                    }
                    if (astTransformers.afterDeclarations) {
                        transformers = __assign(__assign({}, transformers), { afterDeclarations: astTransformers.afterDeclarations.map(function (transformerPath) {
                                return _this.resolvePath(transformerPath, { nodeResolve: true });
                            }) });
                    }
                }
            }
            // babel jest
            var babelConfigOpt = options.babelConfig;
            var babelConfig;
            if (typeof babelConfigOpt === 'string' || babelConfigOpt === true) {
                babelConfig = {
                    kind: 'file',
                    value: babelConfigOpt === true ? undefined : this.resolvePath(babelConfigOpt),
                };
            }
            else if (babelConfigOpt) {
                babelConfig = {
                    kind: 'inline',
                    value: babelConfigOpt,
                };
            }
            // diagnostics
            var diagnostics;
            var _e = options.diagnostics, diagnosticsOpt = _e === void 0 ? true : _e;
            // messy list of stuff to ignore (will be casted later)
            var ignoreList = [exports.IGNORE_DIAGNOSTIC_CODES, process.env.TS_JEST_IGNORE_DIAGNOSTICS];
            if (diagnosticsOpt === true || diagnosticsOpt == null) {
                diagnostics = { ignoreCodes: [], pretty: true, throws: true };
            }
            else if (diagnosticsOpt === false) {
                diagnostics = {
                    throws: false,
                    pretty: true,
                    ignoreCodes: [],
                    pathRegex: exports.MATCH_NOTHING.source,
                };
            }
            else {
                ignoreList.push(diagnosticsOpt.ignoreCodes);
                diagnostics = {
                    pretty: diagnosticsOpt.pretty == null ? true : !!diagnosticsOpt.pretty,
                    ignoreCodes: [],
                    pathRegex: normalizeRegex(diagnosticsOpt.pathRegex),
                    throws: !diagnosticsOpt.warnOnly,
                };
            }
            // now we clean and flatten the list
            diagnostics.ignoreCodes = toDiagnosticCodeList(ignoreList);
            // stringifyContentPathRegex option
            var stringifyContentPathRegex = normalizeRegex(options.stringifyContentPathRegex);
            // parsed options
            var res = {
                tsConfig: tsConfig,
                packageJson: packageJson,
                babelConfig: babelConfig,
                diagnostics: diagnostics,
                isolatedModules: !!options.isolatedModules,
                compiler: (_c = options.compiler) !== null && _c !== void 0 ? _c : 'typescript',
                transformers: transformers,
                stringifyContentPathRegex: stringifyContentPathRegex,
            };
            this.logger.debug({ tsJestConfig: res }, 'normalized ts-jest config');
            return res;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ConfigSet.prototype, "parsedTsConfig", {
        /**
         * @internal
         */
        get: function () {
            return this._parsedTsConfig;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ConfigSet.prototype, "versions", {
        /**
         * Use by e2e, don't mark as internal
         */
        get: function () {
            var modules = ['jest', this.tsJest.compiler];
            if (this.tsJest.babelConfig) {
                modules.push('@babel/core', 'babel-jest');
            }
            return modules.reduce(function (map, name) {
                var _a;
                map[name] = (_a = get_package_version_1.getPackageVersion(name)) !== null && _a !== void 0 ? _a : '-';
                return map;
            }, { 'ts-jest': __1.version });
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ConfigSet.prototype, "_parsedTsConfig", {
        /**
         * @internal
         */
        get: function () {
            var tsConfig = this.tsJest.tsConfig;
            var configFilePath = (tsConfig === null || tsConfig === void 0 ? void 0 : tsConfig.kind) === 'file' ? tsConfig.value : undefined;
            var result = this.readTsConfig((tsConfig === null || tsConfig === void 0 ? void 0 : tsConfig.kind) === 'inline' ? tsConfig.value : undefined, configFilePath, tsConfig == null);
            // throw errors if any matching wanted diagnostics
            this.raiseDiagnostics(result.errors, configFilePath);
            this.logger.debug({ tsconfig: result }, 'normalized typescript config');
            return result;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ConfigSet.prototype, "raiseDiagnostics", {
        /**
         * @internal
         */
        get: function () {
            var _this = this;
            var _a = this, createTsError = _a.createTsError, filterDiagnostics = _a.filterDiagnostics, throws = _a.tsJest.diagnostics.throws, DiagnosticCategory = _a.compilerModule.DiagnosticCategory;
            return function (diagnostics, filePath, logger) {
                if (logger === void 0) { logger = _this.logger; }
                var filteredDiagnostics = filterDiagnostics(diagnostics, filePath);
                if (!filteredDiagnostics.length)
                    return;
                var error = createTsError(filteredDiagnostics);
                // only throw if `warnOnly` and it is a warning or error
                var importantCategories = [DiagnosticCategory.Warning, DiagnosticCategory.Error];
                if (throws && filteredDiagnostics.some(function (d) { return importantCategories.includes(d.category); })) {
                    throw error;
                }
                logger.warn({ error: error }, error.message);
            };
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ConfigSet.prototype, "babel", {
        /**
         * @internal
         */
        get: function () {
            var babelConfig = this.tsJest.babelConfig;
            if (babelConfig == null) {
                this.logger.debug('babel is disabled');
                return undefined;
            }
            var base = { cwd: this.cwd };
            if (babelConfig.kind === 'file') {
                if (babelConfig.value) {
                    if (path_1.extname(babelConfig.value) === '.js') {
                        base = __assign(__assign({}, base), require(babelConfig.value));
                    }
                    else {
                        base = __assign(__assign({}, base), json5.parse(fs_1.readFileSync(babelConfig.value, 'utf8')));
                    }
                }
            }
            else if (babelConfig.kind === 'inline') {
                base = __assign(__assign({}, base), babelConfig.value);
            }
            this.logger.debug({ babelConfig: base }, 'normalized babel config via ts-jest option');
            return base;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ConfigSet.prototype, "compilerModule", {
        /**
         * This API can be used by custom transformers
         */
        get: function () {
            return importer_1.importer.typescript("Using \"ts-jest\" requires this package to be installed." /* TsJest */, this.tsJest.compiler);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ConfigSet.prototype, "babelJestTransformer", {
        /**
         * @internal
         */
        get: function () {
            var babel = this.babel;
            if (!babel)
                return undefined;
            this.logger.debug('creating babel-jest transformer');
            return importer_1.importer.babelJest("Using \"babel-jest\" requires this package to be installed." /* BabelJest */).createTransformer(babel);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ConfigSet.prototype, "tsCompiler", {
        get: function () {
            return instance_1.createCompilerInstance(this);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ConfigSet.prototype, "astTransformers", {
        /**
         * @internal
         */
        get: function () {
            var astTransformers = {
                before: __spread(transformers_1.internals),
            };
            var transformers = this.tsJest.transformers;
            if (transformers.before) {
                astTransformers = {
                    before: __spread(astTransformers.before, transformers.before.map(function (transformerFilePath) { return require(transformerFilePath); })),
                };
            }
            if (transformers.after) {
                astTransformers = __assign(__assign({}, astTransformers), { after: transformers.after.map(function (transformerFilePath) { return require(transformerFilePath); }) });
            }
            if (transformers.afterDeclarations) {
                astTransformers = __assign(__assign({}, astTransformers), { afterDeclarations: transformers.afterDeclarations.map(function (transformerFilePath) {
                        return require(transformerFilePath);
                    }) });
            }
            return astTransformers;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ConfigSet.prototype, "tsCustomTransformers", {
        /**
         * @internal
         */
        get: function () {
            var _this = this;
            var customTransformers = {
                before: this.astTransformers.before.map(function (t) { return t.factory(_this); }),
            };
            if (this.astTransformers.after) {
                customTransformers = __assign(__assign({}, customTransformers), { after: this.astTransformers.after.map(function (t) { return t.factory(_this); }) });
            }
            if (this.astTransformers.afterDeclarations) {
                customTransformers = __assign(__assign({}, customTransformers), { afterDeclarations: this.astTransformers.afterDeclarations.map(function (t) { return t.factory(_this); }) });
            }
            return customTransformers;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ConfigSet.prototype, "hooks", {
        /**
         * @internal
         */
        get: function () {
            var hooksFile = process.env.TS_JEST_HOOKS;
            if (hooksFile) {
                hooksFile = path_1.resolve(this.cwd, hooksFile);
                return importer_1.importer.tryTheseOr(hooksFile, {});
            }
            return {};
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ConfigSet.prototype, "filterDiagnostics", {
        /**
         * @internal
         */
        get: function () {
            var _a = this, ignoreCodes = _a.tsJest.diagnostics.ignoreCodes, shouldReportDiagnostic = _a.shouldReportDiagnostic;
            return function (diagnostics, filePath) {
                if (filePath && !shouldReportDiagnostic(filePath))
                    return [];
                return diagnostics.filter(function (diagnostic) {
                    var _a;
                    if (((_a = diagnostic.file) === null || _a === void 0 ? void 0 : _a.fileName) && !shouldReportDiagnostic(diagnostic.file.fileName)) {
                        return false;
                    }
                    return !ignoreCodes.includes(diagnostic.code);
                });
            };
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ConfigSet.prototype, "shouldReportDiagnostic", {
        /**
         * @internal
         */
        get: function () {
            var pathRegex = this.tsJest.diagnostics.pathRegex;
            if (pathRegex) {
                var regex_1 = new RegExp(pathRegex);
                return function (file) { return regex_1.test(file); };
            }
            else {
                return function () { return true; };
            }
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ConfigSet.prototype, "shouldStringifyContent", {
        /**
         * @internal
         */
        get: function () {
            var stringifyContentPathRegex = this.tsJest.stringifyContentPathRegex;
            if (stringifyContentPathRegex) {
                var regex_2 = new RegExp(stringifyContentPathRegex);
                return function (file) { return regex_2.test(file); };
            }
            else {
                return function () { return false; };
            }
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ConfigSet.prototype, "createTsError", {
        /**
         * @internal
         */
        get: function () {
            var _this = this;
            var pretty = this.tsJest.diagnostics.pretty;
            var formatDiagnostics = pretty
                ? this.compilerModule.formatDiagnosticsWithColorAndContext
                : this.compilerModule.formatDiagnostics;
            var diagnosticHost = {
                getNewLine: function () { return '\n'; },
                getCurrentDirectory: function () { return _this.cwd; },
                getCanonicalFileName: function (path) { return path; },
            };
            return function (diagnostics) {
                var diagnosticText = formatDiagnostics(diagnostics, diagnosticHost);
                var diagnosticCodes = diagnostics.map(function (x) { return x.code; });
                return new ts_error_1.TSError(diagnosticText, diagnosticCodes);
            };
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ConfigSet.prototype, "tsCacheDir", {
        /**
         * @internal
         */
        get: function () {
            if (!this.jest.cache) {
                logger.debug('file caching disabled');
                return undefined;
            }
            var cacheSuffix = sha1_1.sha1(json_1.stringify({
                version: this.compilerModule.version,
                digest: this.tsJestDigest,
                compiler: this.tsJest.compiler,
                compilerOptions: this.parsedTsConfig.options,
                isolatedModules: this.tsJest.isolatedModules,
                diagnostics: this.tsJest.diagnostics,
            }));
            var res = path_1.join(this.jest.cacheDirectory, 'ts-jest', cacheSuffix.substr(0, 2), cacheSuffix.substr(2));
            logger.debug({ cacheDirectory: res }, 'will use file caching');
            return res;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ConfigSet.prototype, "overriddenCompilerOptions", {
        /**
         * @internal
         */
        get: function () {
            var options = {
                // we handle sourcemaps this way and not another
                sourceMap: true,
                inlineSourceMap: false,
                inlineSources: true,
                // we don't want to create declaration files
                declaration: false,
                noEmit: false,
                // else istanbul related will be dropped
                removeComments: false,
                // to clear out else it's buggy
                out: undefined,
                outFile: undefined,
                composite: undefined,
                declarationDir: undefined,
                declarationMap: undefined,
                emitDeclarationOnly: undefined,
                sourceRoot: undefined,
                tsBuildInfoFile: undefined,
            };
            // force the module kind if not piping babel-jest
            if (!this.tsJest.babelConfig) {
                // commonjs is required for jest
                options.module = this.compilerModule.ModuleKind.CommonJS;
            }
            return options;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ConfigSet.prototype, "rootDir", {
        /**
         * @internal
         */
        get: function () {
            return path_1.normalize(this.jest.rootDir || this.cwd);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ConfigSet.prototype, "cwd", {
        /**
         * @internal
         */
        get: function () {
            return path_1.normalize(this.jest.cwd || process.cwd());
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ConfigSet.prototype, "tsJestDigest", {
        /**
         * Use by e2e, don't mark as internal
         */
        get: function () {
            return __1.digest;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ConfigSet.prototype, "jsonValue", {
        /**
         * @internal
         */
        get: function () {
            var jest = __assign({}, this.jest);
            var globals = (jest.globals = __assign({}, jest.globals));
            // we need to remove some stuff from jest config
            // this which does not depend on config
            jest.name = undefined;
            jest.cacheDirectory = undefined;
            // we do not need this since its normalized version is in tsJest
            delete globals['ts-jest'];
            return new jsonable_value_1.JsonableValue({
                digest: this.tsJestDigest,
                transformers: Object.values(this.astTransformers)
                    .reduce(function (acc, val) { return acc.concat(val); }, [])
                    .map(function (t) { return t.name + "@" + t.version; }),
                jest: jest,
                tsJest: this.tsJest,
                babel: this.babel,
                tsconfig: {
                    options: this.parsedTsConfig.options,
                    raw: this.parsedTsConfig.raw,
                },
            });
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ConfigSet.prototype, "cacheKey", {
        /**
         * @internal
         */
        get: function () {
            return this.jsonValue.serialized;
        },
        enumerable: false,
        configurable: true
    });
    /**
     * @internal
     */
    ConfigSet.prototype.makeDiagnostic = function (code, messageText, options) {
        if (options === void 0) { options = {}; }
        var _a = options.category, category = _a === void 0 ? this.compilerModule.DiagnosticCategory.Warning : _a, file = options.file, start = options.start, length = options.length;
        return {
            code: code,
            messageText: messageText,
            category: category,
            file: file,
            start: start,
            length: length,
        };
    };
    /**
     * Load TypeScript configuration. Returns the parsed TypeScript config and
     * any `tsConfig` options specified in ts-jest tsConfig
     *
     * @internal
     */
    ConfigSet.prototype.readTsConfig = function (compilerOptions, resolvedConfigFile, noProject) {
        var e_2, _a;
        var _b;
        var config = { compilerOptions: Object.create(null) };
        var basePath = normalize_slashes_1.normalizeSlashes(this.rootDir);
        var configFileName;
        var ts = this.compilerModule;
        if (!noProject) {
            // Read project configuration when available.
            configFileName = resolvedConfigFile
                ? normalize_slashes_1.normalizeSlashes(resolvedConfigFile)
                : ts.findConfigFile(normalize_slashes_1.normalizeSlashes(this.rootDir), ts.sys.fileExists);
            if (configFileName) {
                this.logger.debug({ tsConfigFileName: configFileName }, 'readTsConfig(): reading', configFileName);
                var result_1 = ts.readConfigFile(configFileName, ts.sys.readFile);
                // Return diagnostics.
                if (result_1.error) {
                    return { errors: [result_1.error], fileNames: [], options: {} };
                }
                config = result_1.config;
                basePath = normalize_slashes_1.normalizeSlashes(path_1.dirname(configFileName));
            }
        }
        // Override default configuration options `ts-jest` requires.
        config.compilerOptions = __assign(__assign({}, config.compilerOptions), compilerOptions);
        // parse json, merge config extending others, ...
        var result = ts.parseJsonConfigFileContent(config, ts.sys, basePath, undefined, configFileName);
        var forcedOptions = this.overriddenCompilerOptions;
        var finalOptions = result.options;
        // Target ES5 output by default (instead of ES3).
        if (finalOptions.target === undefined) {
            finalOptions.target = ts.ScriptTarget.ES5;
        }
        // check the module interoperability
        var target = finalOptions.target;
        // compute the default if not set
        var defaultModule = [ts.ScriptTarget.ES3, ts.ScriptTarget.ES5].includes(target)
            ? ts.ModuleKind.CommonJS
            : ts.ModuleKind.ESNext;
        var moduleValue = finalOptions.module == null ? defaultModule : finalOptions.module;
        if ('module' in forcedOptions &&
            moduleValue !== forcedOptions.module &&
            !(finalOptions.esModuleInterop || finalOptions.allowSyntheticDefaultImports)) {
            result.errors.push(this.makeDiagnostic(151001 /* ConfigModuleOption */, "If you have issues related to imports, you should consider setting `esModuleInterop` to `true` in your TypeScript configuration file (usually `tsconfig.json`). See https://blogs.msdn.microsoft.com/typescript/2018/01/31/announcing-typescript-2-7/#easier-ecmascript-module-interoperability for more information." /* ConfigNoModuleInterop */, {
                category: ts.DiagnosticCategory.Message,
            }));
            // at least enable synthetic default imports (except if it's set in the input config)
            if (!('allowSyntheticDefaultImports' in config.compilerOptions)) {
                finalOptions.allowSyntheticDefaultImports = true;
            }
        }
        // Make sure when allowJs is enabled, outDir is required to have when using allowJs: true
        if (finalOptions.allowJs && !finalOptions.outDir) {
            finalOptions.outDir = exports.TS_JEST_OUT_DIR;
        }
        try {
            // ensure undefined are removed and other values are overridden
            for (var _c = __values(Object.keys(forcedOptions)), _d = _c.next(); !_d.done; _d = _c.next()) {
                var key = _d.value;
                var val = forcedOptions[key];
                if (val === undefined) {
                    delete finalOptions[key];
                }
                else {
                    finalOptions[key] = val;
                }
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_d && !_d.done && (_a = _c.return)) _a.call(_c);
            }
            finally { if (e_2) throw e_2.error; }
        }
        /**
         * See https://github.com/microsoft/TypeScript/wiki/Node-Target-Mapping
         * Every time this page is updated, we also need to update here. Here we only show warning message for Node LTS versions
         */
        var nodeJsVer = process.version;
        // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
        var compilationTarget = result.options.target;
        if (!this.tsJest.babelConfig &&
            ((nodeJsVer.startsWith('v10') && compilationTarget > typescript_1.ScriptTarget.ES2018) ||
                (nodeJsVer.startsWith('v12') && compilationTarget > typescript_1.ScriptTarget.ES2019))) {
            var message = messages_1.interpolate("There is a mismatch between your NodeJs version {{nodeJsVer}} and your TypeScript target {{compilationTarget}}. This might lead to some unexpected errors when running tests with `ts-jest`. To fix this, you can check https://github.com/microsoft/TypeScript/wiki/Node-Target-Mapping" /* MismatchNodeTargetMapping */, {
                nodeJsVer: process.version,
                compilationTarget: (_b = config.compilerOptions.target) !== null && _b !== void 0 ? _b : TARGET_TO_VERSION_MAPPING[compilationTarget],
            });
            logger.warn(message);
        }
        return result;
    };
    /**
     * @internal
     */
    ConfigSet.prototype.resolvePath = function (inputPath, _a) {
        var _b = _a === void 0 ? {} : _a, _c = _b.throwIfMissing, throwIfMissing = _c === void 0 ? true : _c, _d = _b.nodeResolve, nodeResolve = _d === void 0 ? false : _d;
        var path = inputPath;
        var nodeResolved = false;
        if (path.startsWith('<rootDir>')) {
            path = path_1.resolve(path_1.join(this.rootDir, path.substr(9)));
        }
        else if (!path_1.isAbsolute(path)) {
            if (!path.startsWith('.') && nodeResolve) {
                try {
                    path = require.resolve(path);
                    nodeResolved = true;
                }
                catch (_) { }
            }
            if (!nodeResolved) {
                path = path_1.resolve(this.cwd, path);
            }
        }
        if (!nodeResolved && nodeResolve) {
            try {
                path = require.resolve(path);
                nodeResolved = true;
            }
            catch (_) { }
        }
        if (throwIfMissing && !fs_1.existsSync(path)) {
            throw new Error(messages_1.interpolate("File not found: {{inputPath}} (resolved as: {{resolvedPath}})" /* FileNotFound */, { inputPath: inputPath, resolvedPath: path }));
        }
        this.logger.debug({ fromPath: inputPath, toPath: path }, 'resolved path from', inputPath, 'to', path);
        return path;
    };
    /**
     * @internal
     */
    ConfigSet.prototype.toJSON = function () {
        return this.jsonValue.value;
    };
    __decorate([
        memoize_1.Memoize()
    ], ConfigSet.prototype, "jest", null);
    __decorate([
        memoize_1.Memoize()
    ], ConfigSet.prototype, "isTestFile", null);
    __decorate([
        memoize_1.Memoize()
    ], ConfigSet.prototype, "tsJest", null);
    __decorate([
        memoize_1.Memoize()
    ], ConfigSet.prototype, "versions", null);
    __decorate([
        memoize_1.Memoize()
    ], ConfigSet.prototype, "_parsedTsConfig", null);
    __decorate([
        memoize_1.Memoize()
    ], ConfigSet.prototype, "raiseDiagnostics", null);
    __decorate([
        memoize_1.Memoize()
    ], ConfigSet.prototype, "babel", null);
    __decorate([
        memoize_1.Memoize()
    ], ConfigSet.prototype, "compilerModule", null);
    __decorate([
        memoize_1.Memoize()
    ], ConfigSet.prototype, "babelJestTransformer", null);
    __decorate([
        memoize_1.Memoize()
    ], ConfigSet.prototype, "tsCompiler", null);
    __decorate([
        memoize_1.Memoize()
    ], ConfigSet.prototype, "astTransformers", null);
    __decorate([
        memoize_1.Memoize()
    ], ConfigSet.prototype, "tsCustomTransformers", null);
    __decorate([
        memoize_1.Memoize()
    ], ConfigSet.prototype, "hooks", null);
    __decorate([
        memoize_1.Memoize()
    ], ConfigSet.prototype, "filterDiagnostics", null);
    __decorate([
        memoize_1.Memoize()
    ], ConfigSet.prototype, "shouldReportDiagnostic", null);
    __decorate([
        memoize_1.Memoize()
    ], ConfigSet.prototype, "shouldStringifyContent", null);
    __decorate([
        memoize_1.Memoize()
    ], ConfigSet.prototype, "createTsError", null);
    __decorate([
        memoize_1.Memoize()
    ], ConfigSet.prototype, "tsCacheDir", null);
    __decorate([
        memoize_1.Memoize()
    ], ConfigSet.prototype, "overriddenCompilerOptions", null);
    __decorate([
        memoize_1.Memoize()
    ], ConfigSet.prototype, "rootDir", null);
    __decorate([
        memoize_1.Memoize()
    ], ConfigSet.prototype, "cwd", null);
    __decorate([
        memoize_1.Memoize()
    ], ConfigSet.prototype, "tsJestDigest", null);
    __decorate([
        memoize_1.Memoize()
    ], ConfigSet.prototype, "jsonValue", null);
    return ConfigSet;
}());
exports.ConfigSet = ConfigSet;
