import { createJestPreset as createJestPresetCore } from './config/create-jest-preset';
import { TsJestTransformer } from './ts-jest-transformer';
import type { TsJestGlobalOptions } from './types';
import { mocked as mockedCore } from './util/testing';
declare module '@jest/types' {
    namespace Config {
        interface ConfigGlobals {
            'ts-jest': TsJestGlobalOptions;
        }
    }
}
/** @deprecated */
export declare const mocked: typeof mockedCore;
/** @deprecated */
export declare const createJestPreset: typeof createJestPresetCore;
/** @deprecated */
export declare const pathsToModuleNameMapper: (mapping: import("typescript").MapLike<string[]>, { prefix }?: {
    prefix?: string | undefined;
}) => {
    [key: string]: string | string[];
} | undefined;
export declare function createTransformer(baseConfig?: TsJestGlobalOptions): TsJestTransformer;
declare const jestPreset: Pick<Partial<{
    automock: boolean;
    bail: number | boolean;
    cache: boolean;
    cacheDirectory: string;
    clearMocks: boolean;
    changedFilesWithAncestor: boolean;
    changedSince: string;
    collectCoverage: boolean;
    collectCoverageFrom: string[];
    collectCoverageOnlyFrom: {
        [key: string]: boolean;
    };
    coverageDirectory: string;
    coveragePathIgnorePatterns: string[];
    coverageProvider: "babel" | "v8";
    coverageReporters: import("@jest/types/build/Config").CoverageReporters;
    coverageThreshold: {
        global: {
            [key: string]: number;
        };
    };
    dependencyExtractor: string;
    detectLeaks: boolean;
    detectOpenHandles: boolean;
    displayName: string | import("@jest/types/build/Config").DisplayName;
    expand: boolean;
    extraGlobals: string[];
    filter: string;
    findRelatedTests: boolean;
    forceCoverageMatch: string[];
    forceExit: boolean;
    json: boolean;
    globals: import("@jest/types/build/Config").ConfigGlobals;
    globalSetup: string | null | undefined;
    globalTeardown: string | null | undefined;
    haste: import("@jest/types/build/Config").HasteConfig;
    reporters: (string | import("@jest/types/build/Config").ReporterConfig)[];
    logHeapUsage: boolean;
    lastCommit: boolean;
    listTests: boolean;
    mapCoverage: boolean;
    maxConcurrency: number;
    maxWorkers: string | number;
    moduleDirectories: string[];
    moduleFileExtensions: string[];
    moduleLoader: string;
    moduleNameMapper: {
        [key: string]: string | string[];
    };
    modulePathIgnorePatterns: string[];
    modulePaths: string[];
    name: string;
    noStackTrace: boolean;
    notify: boolean;
    notifyMode: string;
    onlyChanged: boolean;
    outputFile: string;
    passWithNoTests: boolean;
    preprocessorIgnorePatterns: string[];
    preset: string | null | undefined;
    prettierPath: string | null | undefined;
    projects: string[];
    replname: string | null | undefined;
    resetMocks: boolean;
    resetModules: boolean;
    resolver: string | null | undefined;
    restoreMocks: boolean;
    rootDir: string;
    roots: string[];
    runner: string;
    runTestsByPath: boolean;
    scriptPreprocessor: string;
    setupFiles: string[];
    setupTestFrameworkScriptFile: string;
    setupFilesAfterEnv: string[];
    silent: boolean;
    skipFilter: boolean;
    skipNodeResolution: boolean;
    slowTestThreshold: number;
    snapshotResolver: string;
    snapshotSerializers: string[];
    errorOnDeprecated: boolean;
    testEnvironment: string;
    testEnvironmentOptions: Record<string, any>;
    testFailureExitCode: string | number;
    testLocationInResults: boolean;
    testMatch: string[];
    testNamePattern: string;
    testPathDirs: string[];
    testPathIgnorePatterns: string[];
    testRegex: string | string[];
    testResultsProcessor: string;
    testRunner: string;
    testSequencer: string;
    testURL: string;
    testTimeout: number;
    timers: "real" | "fake";
    transform: {
        [regex: string]: string | import("@jest/types/build/Config").TransformerConfig;
    };
    transformIgnorePatterns: string[];
    watchPathIgnorePatterns: string[];
    unmockedModulePathPatterns: string[];
    updateSnapshot: boolean;
    useStderr: boolean;
    verbose?: boolean | undefined;
    watch: boolean;
    watchAll: boolean;
    watchman: boolean;
    watchPlugins: (string | [string, Record<string, any>])[];
}>, "moduleFileExtensions" | "testMatch" | "transform">;
export { jestPreset, };
