import { ButtonProps, FormProps } from '@patternfly/react-core';
import React, { ReactNode } from 'react';
export declare const FormContext: React.Context<{
    readonly validate: boolean;
    setValidate: (validate: boolean) => void;
    readonly errors: {
        [id: string]: string | undefined;
    };
    setError: (id: string, error?: string | undefined) => void;
    readonly isReadOnly: boolean;
    setReadOnly: (disabled: boolean) => void;
}>;
export declare function AcmFormProvider(props: {
    children: ReactNode;
}): JSX.Element;
export declare function useFormContext(): {
    readonly validate: boolean;
    setValidate: (validate: boolean) => void;
    readonly errors: {
        [id: string]: string | undefined;
    };
    setError: (id: string, error?: string | undefined) => void;
    readonly isReadOnly: boolean;
    setReadOnly: (disabled: boolean) => void;
};
export declare function AcmForm(props: FormProps): JSX.Element;
declare type AcmSubmitProps = ButtonProps & {
    label?: string;
    processingLabel?: string;
};
export declare function AcmSubmit(props: AcmSubmitProps): JSX.Element;
export {};
