import { __rest } from "tslib";
import * as React from 'react';
import hoistNonReactStatics from 'hoist-non-react-statics';
import { VictoryLine } from 'victory-line';
import { ChartContainer } from '../ChartContainer';
import { getTheme } from '../ChartUtils';
export var ChartLineSortOrder;
(function (ChartLineSortOrder) {
    ChartLineSortOrder["ascending"] = "ascending";
    ChartLineSortOrder["descending"] = "descending";
})(ChartLineSortOrder || (ChartLineSortOrder = {}));
export const ChartLine = (_a) => {
    var { containerComponent = React.createElement(ChartContainer, null), themeColor, themeVariant, 
    // destructure last
    theme = getTheme(themeColor, themeVariant) } = _a, rest = __rest(_a, ["containerComponent", "themeColor", "themeVariant", "theme"]);
    // Clone so users can override container props
    const container = React.cloneElement(containerComponent, Object.assign({ theme }, containerComponent.props));
    // Note: containerComponent is required for theme
    return React.createElement(VictoryLine, Object.assign({ containerComponent: container, theme: theme }, rest));
};
ChartLine.displayName = 'ChartLine';
// Note: VictoryLine.role must be hoisted
hoistNonReactStatics(ChartLine, VictoryLine);
//# sourceMappingURL=ChartLine.js.map