import { __rest } from "tslib";
import * as React from 'react';
import hoistNonReactStatics from 'hoist-non-react-statics';
import { VictoryLegend } from 'victory-legend';
import { ChartContainer } from '../ChartContainer';
import { ChartLabel } from '../ChartLabel';
import { ChartPoint } from '../ChartPoint';
import { getTheme } from '../ChartUtils';
export var ChartLegendOrientation;
(function (ChartLegendOrientation) {
    ChartLegendOrientation["horizontal"] = "horizontal";
    ChartLegendOrientation["vertical"] = "vertical";
})(ChartLegendOrientation || (ChartLegendOrientation = {}));
export var ChartLegendPosition;
(function (ChartLegendPosition) {
    ChartLegendPosition["bottom"] = "bottom";
    ChartLegendPosition["bottomLeft"] = "bottom-left";
    ChartLegendPosition["right"] = "right";
})(ChartLegendPosition || (ChartLegendPosition = {}));
export var ChartLegendRowGutter;
(function (ChartLegendRowGutter) {
    ChartLegendRowGutter["bottom"] = "bottom";
    ChartLegendRowGutter["top"] = "top";
})(ChartLegendRowGutter || (ChartLegendRowGutter = {}));
export const ChartLegend = (_a) => {
    var { containerComponent = React.createElement(ChartContainer, null), dataComponent = React.createElement(ChartPoint, null), labelComponent = React.createElement(ChartLabel, null), responsive = true, themeColor, themeVariant, titleComponent = React.createElement(ChartLabel, null), 
    // destructure last
    theme = getTheme(themeColor, themeVariant) } = _a, rest = __rest(_a, ["containerComponent", "dataComponent", "labelComponent", "responsive", "themeColor", "themeVariant", "titleComponent", "theme"]);
    // Clone so users can override container props
    const container = React.cloneElement(containerComponent, Object.assign({ responsive,
        theme }, containerComponent.props));
    // Note: containerComponent is required for theme
    return (React.createElement(VictoryLegend, Object.assign({ containerComponent: container, dataComponent: dataComponent, labelComponent: labelComponent, theme: theme, titleComponent: titleComponent }, rest)));
};
ChartLegend.displayName = 'ChartLegend';
// Note: VictoryLegend.role must be hoisted, but getBaseProps causes error with ChartVoronoiContainer
hoistNonReactStatics(ChartLegend, VictoryLegend, { getBaseProps: true });
ChartLegend.getBaseProps = (props) => {
    const theme = getTheme(null, null);
    return VictoryLegend.getBaseProps(Object.assign({ titleComponent: React.createElement(ChartLabel, null) }, props), {
        height: theme.chart.height,
        orientation: theme.legend.orientation,
        titleOrientation: theme.legend.titleOrientation,
        x: 0,
        y: 0,
        width: theme.chart.width
    });
};
//# sourceMappingURL=ChartLegend.js.map