# contains-path [![NPM version](https://img.shields.io/npm/v/contains-path.svg?style=flat)](https://www.npmjs.com/package/contains-path) [![NPM monthly downloads](https://img.shields.io/npm/dm/contains-path.svg?style=flat)](https://npmjs.org/package/contains-path) [![Linux Build Status](https://img.shields.io/travis/jonschlinkert/contains-path.svg?style=flat&label=Travis)](https://travis-ci.org/jonschlinkert/contains-path) [![Windows Build Status](https://img.shields.io/appveyor/ci/jonschlinkert/contains-path.svg?style=flat&label=AppVeyor)](https://ci.appveyor.com/project/jonschlinkert/contains-path)

> Return true if a file path contains the given path.

## Install

Install with [npm](https://www.npmjs.com/):

```sh
$ npm install --save contains-path
```

Install with [yarn](https://yarnpkg.com):

```sh
$ yarn add contains-path
```

## HEADS UP!

As of v1.0.0, this library no longer uses regex for matching. Please do not hesitate to [report any issues or regressiosn](../../issues/new).

## Usage

```js
var containsPath = require('contains-path');

containsPath('foo/bar', 'foo'); //=> true
containsPath('foo/bar', 'bar'); //=> true
containsPath('foo/bar', 'qux'); //=> false

// returns false for partial matches
containsPath('foobar', 'foo');  //=> false
containsPath('foo.bar', 'foo'); //=> false
containsPath('foo.bar', 'bar'); //=> false

// prefix with "./" to match from beginning of filepath
containsPath('bar/foo', 'foo');   //=> true
containsPath('bar/foo', './foo'); //=> false
```

## Negation

Prefix with `!` to invert matching behavior:

```js
containsPath('foo/bar', '!foo'); //=> false
containsPath('foo/bar', '!qux'); //=> true
```

## Options

### options.nocase

**Type**: `boolean`

**Default**: `false`

Disable case sensitivity.

```js
containsPath('foo/bar', 'FOO');                 //=> false
containsPath('foo/bar', 'FOO', {nocase: true}); //=> true
```

### options.partialMatch

**Type**: `boolean`

**Default**: `false`

Allow "partial" matches:

```js
containsPath('foobar', 'foo');                        //=> false                 
containsPath('foobar', 'foo', {partialMatch: true});  //=> true 

containsPath('foo.bar', 'foo');                       //=> false                 
containsPath('foo.bar', 'foo', {partialMatch: true}); //=> true 
```

## About

### Related projects

* [ends-with](https://www.npmjs.com/package/ends-with): Returns `true` if the given `string` or `array` ends with `suffix` using strict equality for… [more](https://github.com/jonschlinkert/ends-with) | [homepage](https://github.com/jonschlinkert/ends-with "Returns `true` if the given `string` or `array` ends with `suffix` using strict equality for comparisons.")
* [normalize-path](https://www.npmjs.com/package/normalize-path): Normalize file path slashes to be unix-like forward slashes. Also condenses repeat slashes to a… [more](https://github.com/jonschlinkert/normalize-path) | [homepage](https://github.com/jonschlinkert/normalize-path "Normalize file path slashes to be unix-like forward slashes. Also condenses repeat slashes to a single slash and removes and trailing slashes unless disabled.")
* [path-ends-with](https://www.npmjs.com/package/path-ends-with): Return `true` if a file path ends with the given string/suffix. | [homepage](https://github.com/jonschlinkert/path-ends-with "Return `true` if a file path ends with the given string/suffix.")
* [unixify](https://www.npmjs.com/package/unixify): Convert Windows file paths to unix paths. | [homepage](https://github.com/jonschlinkert/unixify "Convert Windows file paths to unix paths.")

### Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](../../issues/new).

### Contributors

| **Commits** | **Contributor** | 
| --- | --- |
| 2 | [jonschlinkert](https://github.com/jonschlinkert) |
| 1 | [germtb](https://github.com/germtb) |

### Building docs

_(This project's readme.md is generated by [verb](https://github.com/verbose/verb-generate-readme), please don't edit the readme directly. Any changes to the readme must be made in the [.verb.md](.verb.md) readme template.)_

To generate the readme, run the following command:

```sh
$ npm install -g verbose/verb#dev verb-generate-readme && verb
```

### Running tests

Running and reviewing unit tests is a great way to get familiarized with a library and its API. You can install dependencies and run tests with the following command:

```sh
$ npm install && npm test
```

### Author

**Jon Schlinkert**

* [github/jonschlinkert](https://github.com/jonschlinkert)
* [twitter/jonschlinkert](https://twitter.com/jonschlinkert)

### License

Copyright © 2017, [Jon Schlinkert](https://github.com/jonschlinkert).
Released under the [MIT License](LICENSE).

***

_This file was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme), v0.5.0, on April 17, 2017._