"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AcmTile = void 0;
var react_1 = __importDefault(require("react"));
var react_core_1 = require("@patternfly/react-core");
var styles_1 = require("@material-ui/styles");
require("@patternfly/react-core/dist/styles/base.css");
var useStyles = styles_1.makeStyles({
    tileRoot: {
        display: 'flex',
        alignItems: 'center',
        padding: '0 1.5rem',
        height: '64px',
        overflow: 'hidden',
        '& >div:last-child': {
            width: '100%',
        },
    },
    relatedResourceContainer: {
        display: 'flex',
        alignItems: 'center',
    },
    relatedResourceCount: {
        fontSize: '28px',
        color: 'var(--pf-global--palette--blue-400)',
        marginRight: '.5rem',
    },
    relatedResourceKind: {
        fontSize: '14px',
        fontWeight: 'bold',
        overflow: 'hidden',
        textOverflow: 'ellipsis',
        textAlign: 'left',
        lineHeight: '18px',
    },
});
function AcmTile(props) {
    var classes = useStyles(props);
    if (props.loading) {
        return (react_1.default.createElement(react_core_1.Tile, { className: classes.tileRoot, title: '', ref: null },
            react_1.default.createElement(react_core_1.Skeleton, null)));
    }
    if (props.relatedResourceData) {
        // This render is specific to the search related resources tile
        var count = "" + props.relatedResourceData.count;
        if (parseInt(count) >= 1000) {
            count = (parseInt(count) - (parseInt(count) % 100)) / 1000 + "k";
        }
        return (react_1.default.createElement(react_core_1.Tile, { className: classes.tileRoot, title: props.title, onClick: props.onClick, isSelected: props.isSelected, ref: null },
            react_1.default.createElement("div", { className: classes.relatedResourceContainer },
                react_1.default.createElement("div", { className: classes.relatedResourceCount }, count),
                react_1.default.createElement("div", { className: classes.relatedResourceKind }, "Related " + props.relatedResourceData.kind))));
    }
    return react_1.default.createElement(react_core_1.Tile, __assign({}, props, { ref: null }));
}
exports.AcmTile = AcmTile;
//# sourceMappingURL=AcmTile.js.map