import React, { useState } from 'react';
import { css } from '@patternfly/react-styles';
import styles from '@patternfly/react-styles/css/components/TreeView/tree-view';
import AngleRightIcon from "@patternfly/react-icons/dist/esm/icons/angle-right-icon";
import { Badge } from '../Badge';
import { GenerateId } from '../../helpers/GenerateId/GenerateId';
export const TreeViewListItem = ({ name, id, defaultExpanded = false, children = null, onSelect, onCheck, hasCheck = false, checkProps = {
    checked: false
}, hasBadge = false, badgeProps = { isRead: true }, activeItems = [], itemData, parentItem, icon, expandedIcon, action, compareItems }) => {
    const [isExpanded, setIsExpanded] = useState(defaultExpanded);
    const Component = hasCheck ? 'div' : 'button';
    const ToggleComponent = hasCheck ? 'button' : 'div';
    return (React.createElement("li", Object.assign({ id: id, className: css(styles.treeViewListItem, isExpanded && styles.modifiers.expanded) }, (isExpanded && { 'aria-expanded': 'true' }), { role: "treeitem", tabIndex: 0 }),
        React.createElement("div", { className: css(styles.treeViewContent) },
            React.createElement(GenerateId, { prefix: "checkbox-id" }, randomId => (React.createElement(Component, { className: css(styles.treeViewNode, !children &&
                    activeItems &&
                    activeItems.length > 0 &&
                    activeItems.some(item => compareItems && item && compareItems(item, itemData))
                    ? styles.modifiers.current
                    : ''), onClick: (evt) => {
                    if (!hasCheck) {
                        if (children) {
                            setIsExpanded(!isExpanded);
                        }
                        onSelect && onSelect(evt, itemData, parentItem);
                    }
                } },
                children && (React.createElement(ToggleComponent, Object.assign({ className: css(styles.treeViewNodeToggle), onClick: () => {
                        if (hasCheck) {
                            setIsExpanded(!isExpanded);
                        }
                    } }, (hasCheck && { 'aria-labelledby': `label-${randomId}` })),
                    React.createElement("span", { className: css(styles.treeViewNodeToggleIcon) },
                        React.createElement(AngleRightIcon, { "aria-hidden": "true" })))),
                hasCheck && (React.createElement("span", { className: css(styles.treeViewNodeCheck) },
                    React.createElement("input", Object.assign({ type: "checkbox", onChange: (evt) => onCheck && onCheck(evt, itemData, parentItem), onClick: (evt) => evt.stopPropagation(), ref: elem => elem && (elem.indeterminate = checkProps.checked === null) }, checkProps, { id: randomId })))),
                icon && (React.createElement("span", { className: css(styles.treeViewNodeIcon) },
                    !isExpanded && icon,
                    isExpanded && (expandedIcon || icon))),
                hasCheck ? (React.createElement("label", { className: css(styles.treeViewNodeText), htmlFor: randomId, id: `label-${randomId}` }, name)) : (React.createElement("span", { className: css(styles.treeViewNodeText) }, name)),
                hasBadge && children && (React.createElement("span", { className: css(styles.treeViewNodeCount) },
                    React.createElement(Badge, Object.assign({}, badgeProps), children.props.data.length)))))),
            action && React.createElement("div", { className: css(styles.treeViewAction) }, action)),
        isExpanded && children));
};
TreeViewListItem.displayName = 'TreeViewListItem';
//# sourceMappingURL=TreeViewListItem.js.map