"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TreeView = void 0;
const tslib_1 = require("tslib");
const React = tslib_1.__importStar(require("react"));
const react_styles_1 = require("@patternfly/react-styles");
const tree_view_1 = tslib_1.__importDefault(require("@patternfly/react-styles/css/components/TreeView/tree-view"));
const TreeViewList_1 = require("./TreeViewList");
const TreeViewListItem_1 = require("./TreeViewListItem");
exports.TreeView = (_a) => {
    var { data, isNested = false, hasChecks = false, hasBadges = false, defaultAllExpanded = false, icon, expandedIcon, parentItem, onSelect, onCheck, onSearch, searchProps, activeItems, compareItems = (item, itemToCheck) => item.id === itemToCheck.id } = _a, props = tslib_1.__rest(_a, ["data", "isNested", "hasChecks", "hasBadges", "defaultAllExpanded", "icon", "expandedIcon", "parentItem", "onSelect", "onCheck", "onSearch", "searchProps", "activeItems", "compareItems"]);
    const treeViewList = (React.createElement(TreeViewList_1.TreeViewList, { isNested: isNested, onSearch: onSearch, searchProps: searchProps }, data.map(item => (React.createElement(TreeViewListItem_1.TreeViewListItem, Object.assign({ key: item.name.toString(), name: item.name, id: item.id, defaultExpanded: item.defaultExpanded !== undefined ? item.defaultExpanded : defaultAllExpanded, onSelect: onSelect, onCheck: onCheck, hasCheck: item.hasCheck !== undefined ? item.hasCheck : hasChecks, checkProps: item.checkProps, hasBadge: item.hasBadge !== undefined ? item.hasBadge : hasBadges, badgeProps: item.badgeProps, activeItems: activeItems, parentItem: parentItem, itemData: item, icon: item.icon !== undefined ? item.icon : icon, expandedIcon: item.expandedIcon !== undefined ? item.expandedIcon : expandedIcon, action: item.action, compareItems: compareItems }, (item.children && {
        children: (React.createElement(exports.TreeView, { data: item.children, isNested: true, parentItem: item, hasChecks: hasChecks, hasBadges: hasBadges, defaultAllExpanded: defaultAllExpanded, onSelect: onSelect, onCheck: onCheck, activeItems: activeItems, icon: icon, expandedIcon: expandedIcon }))
    })))))));
    return (React.createElement(React.Fragment, null, parentItem ? (treeViewList) : (React.createElement("div", Object.assign({ className: react_styles_1.css(tree_view_1.default.treeView) }, props), treeViewList))));
};
exports.TreeView.displayName = 'TreeView';
//# sourceMappingURL=TreeView.js.map