"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.processManifest = exports.injectScript = exports.getAppsByRootLocation = exports.getAppData = exports.getApp = exports.initializeApp = exports.unmountAll = exports.unmountAppsFromRoute = exports.removeActiveApp = exports.setActiveApp = exports.initialize = exports.setPendingInjection = exports.getScalprum = exports.GLOBAL_NAMESPACE = void 0;
exports.GLOBAL_NAMESPACE = '__scalprum__';
exports.getScalprum = function () { return window[exports.GLOBAL_NAMESPACE]; };
var generateScalpletRoutes = function (scalpLets) {
    var routes = {};
    Object.values(scalpLets).forEach(function (_a) {
        var rootLocation = _a.rootLocation, name = _a.name;
        if (rootLocation && routes[rootLocation]) {
            routes[rootLocation].push(name);
        }
        else if (rootLocation) {
            routes[rootLocation] = [name];
        }
    });
    return routes;
};
exports.setPendingInjection = function (id, callback) {
    window[exports.GLOBAL_NAMESPACE].pendingInjections[id] = callback;
};
exports.initialize = function (_a) {
    var scalpLets = _a.scalpLets, api = _a.api;
    window[exports.GLOBAL_NAMESPACE] = __assign({ apps: {}, appsMetaData: scalpLets, activeApps: {}, scalpletRoutes: generateScalpletRoutes(scalpLets), pendingInjections: {} }, api);
};
exports.setActiveApp = function (name) {
    window[exports.GLOBAL_NAMESPACE].activeApps[name] = true;
};
exports.removeActiveApp = function (name) {
    window[exports.GLOBAL_NAMESPACE].activeApps[name] = false;
};
exports.unmountAppsFromRoute = function (route) {
    var _a;
    (_a = window[exports.GLOBAL_NAMESPACE].scalpletRoutes[route]) === null || _a === void 0 ? void 0 : _a.forEach(function (name) { return window[exports.GLOBAL_NAMESPACE].apps[name].unmount(); });
};
exports.unmountAll = function () {
    Object.entries(window[exports.GLOBAL_NAMESPACE].activeApps).filter(function (_a) {
        var name = _a[0], isActive = _a[1];
        if (isActive) {
            window[exports.GLOBAL_NAMESPACE].apps[name].unmount();
        }
    });
};
function initializeApp(configuration) {
    if (typeof window[exports.GLOBAL_NAMESPACE] === 'undefined') {
        throw 'Cannot inititlize app. Scalprum was not inititliazed!';
    }
    window[exports.GLOBAL_NAMESPACE].apps[configuration.name] = {
        mount: function (api) {
            var fullApi = __assign(__assign({}, api), window[exports.GLOBAL_NAMESPACE]);
            exports.setActiveApp(configuration.name);
            return configuration.mount(fullApi);
        },
        unmount: function () {
            exports.removeActiveApp(configuration.name);
            configuration.unmount();
        },
        update: configuration.update,
        nodeId: configuration.id,
    };
    window[exports.GLOBAL_NAMESPACE].pendingInjections[configuration.name]();
}
exports.initializeApp = initializeApp;
exports.getApp = function (name) { return window[exports.GLOBAL_NAMESPACE].apps[name]; };
exports.getAppData = function (name) { return window[exports.GLOBAL_NAMESPACE].appsMetaData[name]; };
exports.getAppsByRootLocation = function (pathname) {
    return Object.keys(window[exports.GLOBAL_NAMESPACE].appsMetaData)
        .filter(function (key) { return window[exports.GLOBAL_NAMESPACE].appsMetaData[key].rootLocation === pathname; })
        .map(function (key) { return (__assign(__assign({}, window[exports.GLOBAL_NAMESPACE].appsMetaData[key]), { name: key })); });
};
exports.injectScript = function (appName, scriptLocation, skipPending) {
    if (skipPending === void 0) { skipPending = false; }
    var s = undefined;
    var injectionPromise = new Promise(function (res, rej) {
        s = document.createElement('script');
        s.src = scriptLocation;
        s.id = appName;
        if (skipPending) {
            s.onload = function () {
                res([name, s]);
            };
        }
        else {
            exports.setPendingInjection(appName, function () { return res([name, s]); });
        }
        s.onerror = function () {
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                args[_i] = arguments[_i];
            }
            console.log(args);
            if (skipPending) {
                rej([args, s]);
            }
            else {
                exports.setPendingInjection(appName, function () { return rej([args, s]); });
            }
        };
    });
    if (typeof s !== 'undefined') {
        document.body.appendChild(s);
    }
    return injectionPromise;
};
function processManifest(url, appName, scope, processor) {
    return __awaiter(this, void 0, void 0, function () {
        var manifest;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4, fetch(url)];
                case 1: return [4, (_a.sent()).json()];
                case 2:
                    manifest = _a.sent();
                    return [2, Promise.all(Object.entries(manifest)
                            .filter(function (_a) {
                            var key = _a[0];
                            return (scope ? key === scope : true);
                        })
                            .flatMap(processor || (function (value) { return value[1].entry || value; }))
                            .map(function (scriptLocation) { return exports.injectScript(appName, scriptLocation, true); }))];
            }
        });
    });
}
exports.processManifest = processManifest;
//# sourceMappingURL=index.js.map