"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _Grid = require("@patternfly/react-core/dist/js/layouts/Grid/Grid.js");

var _GridItem = require("@patternfly/react-core/dist/js/layouts/Grid/GridItem.js");

var _Stack = require("@patternfly/react-core/dist/js/layouts/Stack/Stack.js");

var _StackItem = require("@patternfly/react-core/dist/js/layouts/Stack/StackItem.js");

var _Title = require("@patternfly/react-core/dist/js/components/Title/Title.js");

var _Text = require("@patternfly/react-core/dist/js/components/Text/Text.js");

var _RuleFeedback = _interopRequireWildcard(require("./RuleFeedback"));

var _Markdown = _interopRequireDefault(require("../Markdown"));

var _constants = require("./constants");

var _RiskDescription = _interopRequireDefault(require("./RiskDescription"));

var _dot = _interopRequireDefault(require("dot"));

var _RiskOfChangeIcon = require("./RiskOfChangeIcon");

require("./index.css");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var templateProcessor = function templateProcessor(template, definitions) {
  return definitions ? _dot["default"].template(template, _objectSpread(_objectSpread({}, _dot["default"].templateSettings), {}, {
    varname: ['pydata'],
    strip: false
  }))(definitions) : template;
};

var ReportDetails = function ReportDetails(_ref) {
  var details = _ref.details,
      ruleId = _ref.ruleId,
      totalRisk = _ref.totalRisk,
      riskOfChange = _ref.riskOfChange,
      showRiskDescription = _ref.showRiskDescription,
      definitions = _ref.definitions,
      createdAt = _ref.createdAt,
      userVote = _ref.userVote,
      title = _ref.title,
      actions = _ref.actions,
      onFeedbackChanged = _ref.onFeedbackChanged;
  return /*#__PURE__*/_react["default"].createElement(_Grid.Grid, {
    className: "ins-c-rule__report-detail",
    hasGutter: true,
    gutter: "md"
  }, title && actions && /*#__PURE__*/_react["default"].createElement(_react["default"].Fragment, null, /*#__PURE__*/_react["default"].createElement(_GridItem.GridItem, {
    span: 8
  }, /*#__PURE__*/_react["default"].createElement(_Stack.Stack, null, /*#__PURE__*/_react["default"].createElement(_StackItem.StackItem, null, title), createdAt && /*#__PURE__*/_react["default"].createElement(_StackItem.StackItem, null, /*#__PURE__*/_react["default"].createElement(_Text.Text, null, "Published date: ", createdAt)))), /*#__PURE__*/_react["default"].createElement(_GridItem.GridItem, {
    span: 4,
    className: "ins-c-rule__report-detail-actions"
  }, actions)), /*#__PURE__*/_react["default"].createElement(_GridItem.GridItem, {
    span: 8
  }, /*#__PURE__*/_react["default"].createElement(_Stack.Stack, {
    hasGutter: true,
    gutter: "md"
  }, /*#__PURE__*/_react["default"].createElement(_StackItem.StackItem, null, /*#__PURE__*/_react["default"].createElement("div", null, /*#__PURE__*/_react["default"].createElement(_Markdown["default"], {
    template: details,
    definitions: definitions
  }))), /*#__PURE__*/_react["default"].createElement(_StackItem.StackItem, null, onFeedbackChanged && /*#__PURE__*/_react["default"].createElement(_RuleFeedback["default"], {
    userVote: userVote,
    ruleId: ruleId,
    onFeedbackChanged: onFeedbackChanged
  })))), /*#__PURE__*/_react["default"].createElement(_GridItem.GridItem, {
    span: 4
  }, /*#__PURE__*/_react["default"].createElement(_Stack.Stack, {
    hasGutter: true,
    gutter: "md"
  }, /*#__PURE__*/_react["default"].createElement(_StackItem.StackItem, null, /*#__PURE__*/_react["default"].createElement(_Stack.Stack, null, /*#__PURE__*/_react["default"].createElement(_StackItem.StackItem, null, /*#__PURE__*/_react["default"].createElement(_Title.Title, {
    headingLevel: "h1",
    className: "ins-c-rule__risk-detail-title",
    size: "md"
  }, "Total risk")), /*#__PURE__*/_react["default"].createElement(_StackItem.StackItem, null, /*#__PURE__*/_react["default"].createElement(_RiskDescription["default"], {
    riskValue: totalRisk,
    riskMeta: _constants.totalRiskMeta,
    showDescription: showRiskDescription
  })))), riskOfChange > 0 && riskOfChange < 5 && /*#__PURE__*/_react["default"].createElement(_StackItem.StackItem, null, /*#__PURE__*/_react["default"].createElement(_Stack.Stack, null, /*#__PURE__*/_react["default"].createElement(_StackItem.StackItem, null, /*#__PURE__*/_react["default"].createElement(_Title.Title, {
    headingLevel: "h1",
    className: "ins-c-rule__risk-detail-title",
    size: "md"
  }, "Risk of change")), /*#__PURE__*/_react["default"].createElement(_StackItem.StackItem, null, /*#__PURE__*/_react["default"].createElement(_RiskDescription["default"], {
    riskValue: riskOfChange,
    riskMeta: _RiskOfChangeIcon.riskOfChangeMeta,
    showDescription: showRiskDescription
  })))))));
};

ReportDetails.propTypes = {
  details: _propTypes["default"].string,
  ruleId: _propTypes["default"].string,
  totalRisk: _propTypes["default"].number,
  riskOfChange: _propTypes["default"].number,
  userVote: _propTypes["default"].oneOf(Object.values(_RuleFeedback.feedback)),
  showRiskDescription: _propTypes["default"].bool,
  definitions: _propTypes["default"].object,
  createdAt: _propTypes["default"].node,
  title: _propTypes["default"].node,
  actions: _propTypes["default"].node,
  onFeedbackChanged: _propTypes["default"].func
};
ReportDetails.defaultProps = {
  showRiskDescription: true,
  userVote: 0
};
var _default = ReportDetails;
exports["default"] = _default;