import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _assertThisInitialized from "@babel/runtime/helpers/assertThisInitialized";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _defineProperty from "@babel/runtime/helpers/defineProperty";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Table, TableBody, TableHeader, sortable } from '@patternfly/react-table';
import { Bullseye } from "@patternfly/react-core/dist/esm/layouts/Bullseye/Bullseye.js";
import { EmptyState } from "@patternfly/react-core/dist/esm/components/EmptyState/EmptyState.js";
import { EmptyStateIcon } from "@patternfly/react-core/dist/esm/components/EmptyState/EmptyStateIcon.js";
import { Title } from "@patternfly/react-core/dist/esm/components/Title/Title.js";
import { EmptyStateBody } from "@patternfly/react-core/dist/esm/components/EmptyState/EmptyStateBody.js";
import { EmptyStateVariant } from "@patternfly/react-core/dist/esm/components/EmptyState/EmptyState.js";
import SearchIcon from "@patternfly/react-icons/dist/esm/icons/search-icon";
import { Skeleton } from '@redhat-cloud-services/frontend-components/Skeleton';
import { TableToolbar } from '@redhat-cloud-services/frontend-components/TableToolbar';
import { PrimaryToolbar } from '@redhat-cloud-services/frontend-components/PrimaryToolbar';
import { Pagination } from "@patternfly/react-core/dist/esm/components/Pagination/Pagination.js";
import { PaginationVariant } from "@patternfly/react-core/dist/esm/components/Pagination/Pagination.js";
import flatten from 'lodash/flatten';
import debounce from 'lodash/debounce';
import isEqual from 'lodash/isEqual';
import { calculateMeta, calculateActiveFilters, createRows } from './helpers';
export { default as style } from './index.scss';

var RuleTable = /*#__PURE__*/function (_Component) {
  _inherits(RuleTable, _Component);

  var _super = _createSuper(RuleTable);

  function RuleTable() {
    var _this;

    _classCallCheck(this, RuleTable);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    _defineProperty(_assertThisInitialized(_this), "state", {
      filterValues: {},
      expanded: []
    });

    _defineProperty(_assertThisInitialized(_this), "debounceFetchData", debounce(function (options) {
      var fetchData = _this.props.fetchData;
      fetchData(options);
    }, 500));

    _defineProperty(_assertThisInitialized(_this), "onUpdate", function () {
      var isDebounce = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
      var _this$props = _this.props,
          fetchData = _this$props.fetchData,
          rules = _this$props.rules,
          columns = _this$props.columns,
          sortBy = _this$props.sortBy,
          detail = _this$props.detail;
      var filterValues = _this.state.filterValues;
      var method = isDebounce ? _this.debounceFetchData : fetchData;
      method({
        meta: calculateMeta(rules.meta),
        filterValues: filterValues,
        sortBy: _objectSpread(_objectSpread({}, sortBy), {}, {
          column: columns[sortBy.index - Boolean(detail)]
        })
      });
    });

    _defineProperty(_assertThisInitialized(_this), "onFilterDelete", function (_e, _ref, isAll) {
      var _ref2 = _slicedToArray(_ref, 1),
          deleteItem = _ref2[0];

      var filterValues = _this.state.filterValues;

      if (isAll) {
        _this.setState({
          filterValues: {}
        }, function () {
          return _this.onUpdate();
        });
      } else {
        if (Array.isArray(filterValues[deleteItem.type])) {
          var activefilter = filterValues[deleteItem.type];

          var _deleteItem$chips = _slicedToArray(deleteItem.chips, 1),
              chipToDelete = _deleteItem$chips[0];

          _this.setState({
            filterValues: _objectSpread(_objectSpread({}, filterValues), {}, _defineProperty({}, deleteItem.type, activefilter.filter(function (item) {
              return item !== chipToDelete.value;
            })))
          }, function () {
            return _this.onUpdate();
          });
        } else {
          delete filterValues[deleteItem.type];

          _this.setState({
            filterValues: filterValues
          }, function () {
            return _this.onUpdate();
          });
        }
      }
    });

    _defineProperty(_assertThisInitialized(_this), "onCollapse", function (_e, key, isOpen, _ref3) {
      var ruleId = _ref3.ruleId;
      var expanded = _this.state.expanded;
      var collapseKey = ruleId || key / 2;

      if (isOpen) {
        _this.setState({
          expanded: [].concat(_toConsumableArray(expanded), [collapseKey])
        });
      } else {
        var currIndex = expanded.findIndex(function (id) {
          return id === collapseKey;
        });
        expanded.splice(currIndex, 1);

        _this.setState({
          expanded: expanded
        });
      }
    });

    _defineProperty(_assertThisInitialized(_this), "onFilterChange", function (type, _e, value) {
      _this.setState({
        filterValues: _objectSpread(_objectSpread({}, _this.state.filterValues), {}, _defineProperty({}, type, value))
      }, function () {
        return _this.onUpdate(true);
      });
    });

    _defineProperty(_assertThisInitialized(_this), "onSort", function (_e, index, direction) {
      var _this$props2 = _this.props,
          fetchData = _this$props2.fetchData,
          rules = _this$props2.rules,
          columns = _this$props2.columns,
          detail = _this$props2.detail;
      var filterValues = _this.state.filterValues;
      fetchData({
        meta: calculateMeta(rules.meta),
        filterValues: filterValues,
        sortBy: {
          index: index,
          direction: direction,
          column: columns[index - Boolean(detail)]
        }
      });
    });

    _defineProperty(_assertThisInitialized(_this), "onPaginate", function (perPage, page) {
      var _this$props3 = _this.props,
          fetchData = _this$props3.fetchData,
          rules = _this$props3.rules,
          columns = _this$props3.columns,
          detail = _this$props3.detail,
          sortBy = _this$props3.sortBy;
      var filterValues = _this.state.filterValues;
      fetchData({
        meta: _objectSpread(_objectSpread({}, calculateMeta(rules.meta)), {}, {
          perPage: perPage,
          page: page
        }),
        filterValues: filterValues,
        sortBy: _objectSpread(_objectSpread({}, sortBy), {}, {
          column: columns[sortBy.index - Boolean(detail)]
        })
      });
    });

    return _this;
  }

  _createClass(RuleTable, [{
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (!isEqual(prevProps.filterValues, this.props.filterValues)) {
        this.setState({
          filterValues: this.props.filterValues
        });
      }
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      this.setState({
        filterValues: this.props.filterValues
      });
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props4 = this.props,
          rules = _this$props4.rules,
          filters = _this$props4.filters,
          columns = _this$props4.columns,
          detail = _this$props4.detail,
          actions = _this$props4.actions,
          ariaLabel = _this$props4.ariaLabel,
          fetchData = _this$props4.fetchData,
          isLoading = _this$props4.isLoading,
          sortBy = _this$props4.sortBy,
          toolbarProps = _this$props4.toolbarProps,
          _filterValues = _this$props4.filterValues,
          loadingBars = _this$props4.loadingBars,
          emptyStateTitle = _this$props4.emptyStateTitle,
          emptyStateDescription = _this$props4.emptyStateDescription,
          emptyStateIcon = _this$props4.emptyStateIcon,
          props = _objectWithoutProperties(_this$props4, ["rules", "filters", "columns", "detail", "actions", "ariaLabel", "fetchData", "isLoading", "sortBy", "toolbarProps", "filterValues", "loadingBars", "emptyStateTitle", "emptyStateDescription", "emptyStateIcon"]);

      var _this$state = this.state,
          expanded = _this$state.expanded,
          filterValues = _this$state.filterValues;
      var meta = rules.meta,
          data = rules.data;
      var defaultMeta = calculateMeta(meta);

      var pagination = _objectSpread(_objectSpread({}, defaultMeta), {}, {
        onPerPageSelect: function onPerPageSelect(_e, perPage) {
          return _this2.onPaginate(perPage, 1);
        },
        onSetPage: function onSetPage(_e, page) {
          return _this2.onPaginate(defaultMeta.perPage, page);
        }
      });

      var filterItems = Object.entries(filters).map(function (_ref4) {
        var _ref5 = _slicedToArray(_ref4, 2),
            key = _ref5[0],
            filter = _ref5[1];

        return _objectSpread({}, filter({
          onChange: function onChange() {
            for (var _len2 = arguments.length, props = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
              props[_key2] = arguments[_key2];
            }

            return _this2.onFilterChange.apply(_this2, [key].concat(props));
          },
          value: filterValues[key],
          filterKey: key
        }));
      });
      return /*#__PURE__*/React.createElement("section", {
        className: "rhcs-c-rules-table"
      }, /*#__PURE__*/React.createElement(PrimaryToolbar, _extends({}, filterItems && filterItems.length > 0 && {
        filterConfig: {
          items: filterItems
        }
      }, {
        activeFiltersConfig: {
          filters: Object.entries(filterValues).map(function (_ref6) {
            var _ref7 = _slicedToArray(_ref6, 2),
                key = _ref7[0],
                value = _ref7[1];

            return calculateActiveFilters(filterItems.find(function (_ref8) {
              var filterKey = _ref8.filterKey;
              return filterKey === key;
            }), value, key);
          }).filter(Boolean),
          onDelete: this.onFilterDelete
        },
        pagination: pagination
      }, toolbarProps)), /*#__PURE__*/React.createElement(Table, _extends({}, props, sortBy && {
        sortBy: sortBy,
        onSort: this.onSort
      }, {
        actions: !isLoading && actions,
        "aria-label": ariaLabel,
        cells: columns.map(function (_ref9) {
          var transforms = _ref9.transforms,
              column = _objectWithoutProperties(_ref9, ["transforms"]);

          return _objectSpread(_objectSpread({}, column), {}, {
            transforms: [].concat(_toConsumableArray(transforms || []), _toConsumableArray(!isLoading && sortBy && !column.disableSort ? [sortable] : []))
          });
        }),
        rows: isLoading ? _toConsumableArray(new Array(loadingBars)).map(function () {
          return {
            cells: [{
              title: /*#__PURE__*/React.createElement(Skeleton, {
                size: "lg"
              }),
              props: {
                colSpan: columns.length + Boolean(actions)
              }
            }]
          };
        }) : data.length > 0 ? flatten(createRows(data, columns, expanded, detail)).filter(Boolean) : [{
          heightAuto: true,
          cells: [{
            props: {
              colSpan: columns.length + Boolean(actions)
            },
            title: /*#__PURE__*/React.createElement(Bullseye, null, /*#__PURE__*/React.createElement(EmptyState, {
              variant: EmptyStateVariant.small
            }, /*#__PURE__*/React.createElement(EmptyStateIcon, {
              icon: emptyStateIcon
            }), /*#__PURE__*/React.createElement(Title, {
              headingLevel: "h2",
              size: "lg"
            }, emptyStateTitle), /*#__PURE__*/React.createElement(EmptyStateBody, null, emptyStateDescription)))
          }]
        }]
      }, !isLoading && detail && data.length > 0 && {
        onCollapse: this.onCollapse
      }), /*#__PURE__*/React.createElement(TableHeader, null), /*#__PURE__*/React.createElement(TableBody, null)), /*#__PURE__*/React.createElement(TableToolbar, {
        isFooter: true
      }, /*#__PURE__*/React.createElement(Pagination, _extends({}, pagination, {
        widgetId: "pagination-options-menu-bottom",
        variant: PaginationVariant.bottom,
        dropDirection: "up"
      }))));
    }
  }]);

  return RuleTable;
}(Component);

RuleTable.propTypes = {
  ariaLabel: PropTypes.string,
  rules: PropTypes.shape({
    meta: PropTypes.shape({
      count: PropTypes.number,
      offset: PropTypes.number,
      limit: PropTypes.offset
    }),
    data: PropTypes.arrayOf(PropTypes.shape(_defineProperty({}, PropTypes.string, PropTypes.any)))
  }),
  isLoading: PropTypes.bool,
  columns: PropTypes.arrayOf(PropTypes.shape({
    title: PropTypes.node,
    selector: PropTypes.oneOfType([PropTypes.string, PropTypes.arrayOf(PropTypes.string), PropTypes.func]),
    disableSort: PropTypes.bool
  })),
  sort: PropTypes.string,
  emptyStateTitle: PropTypes.string,
  emptyStateDescription: PropTypes.node,
  emptyStateIcon: PropTypes.node,
  defaultFilters: PropTypes.arrayOf(PropTypes.shape({})),
  fetchData: PropTypes.func,
  detail: PropTypes.oneOfType([PropTypes.func, PropTypes.node]),
  actions: PropTypes.arrayOf(PropTypes.shape({
    title: PropTypes.node,
    onClick: PropTypes.func
  })),
  sortBy: PropTypes.shape({
    index: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),
    direction: PropTypes.string
  }),
  filterValues: PropTypes.shape(_defineProperty({}, PropTypes.string, PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.string, PropTypes.number])), PropTypes.oneOfType([PropTypes.string, PropTypes.number])]))),
  toolbarProps: PropTypes.any,
  loadingBars: PropTypes.number,
  filters: PropTypes.object
};
RuleTable.defaultProps = {
  rules: {
    data: []
  },
  columns: [],
  ariaLabel: 'Rules table',
  isLoading: false,
  sortBy: {},
  filters: {},
  filterValues: {},
  fetchData: function fetchData() {
    return undefined;
  },
  loadingBars: 5,
  emptyStateTitle: 'No results found',
  emptyStateDescription: 'No results match the filter criteria. Remove all filters or clear all filters to show results.',
  emptyStateIcon: SearchIcon
};
export default RuleTable;