"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.MiddlewareListener = void 0;

var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var MiddlewareListener = /*#__PURE__*/function () {
  function MiddlewareListener() {
    (0, _classCallCheck2["default"])(this, MiddlewareListener);
    this.listeners = new Set();
  }

  (0, _createClass2["default"])(MiddlewareListener, [{
    key: "getListeners",
    value: function getListeners() {
      return this.listeners;
    }
  }, {
    key: "getMiddleware",
    value: function getMiddleware() {
      var _this = this;

      return function () {
        return function (next) {
          return function (action) {
            var preventBubble = _this.callOnAction(action.type, action.payload);

            if (preventBubble) {
              next({
                type: '@@config/action-stopped',
                payload: action
              });
            } else {
              next(action);
            }
          };
        };
      };
    }
  }, {
    key: "addNew",
    value: function addNew(listener) {
      var _this2 = this;

      this.listeners.add(listener);
      return function () {
        return _this2.listeners["delete"](listener);
      };
    }
  }, {
    key: "callOnAction",
    value: function callOnAction(action, data) {
      var stopBubble = false;

      var preventBubble = function preventBubble() {
        return stopBubble = true;
      };

      var listeners = (0, _toConsumableArray2["default"])(this.listeners);

      for (var i = 0; i < listeners.length; i++) {
        listeners[i].on === action && listeners[i].hasOwnProperty('callback') && listeners[i].callback({
          data: data,
          preventBubble: preventBubble
        });
      }

      return stopBubble;
    }
  }]);
  return MiddlewareListener;
}();

exports.MiddlewareListener = MiddlewareListener;
var _default = MiddlewareListener;
exports["default"] = _default;