import _defineProperty from "@babel/runtime/helpers/defineProperty";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var program = require('commander');

var fs = require('fs');

var _require = require('glob'),
    globSync = _require.sync;

var _require2 = require('mkdirp'),
    mkdirpSync = _require2.sync;

var last = require('lodash/last');

var MESSAGES_PATTERN = 'build/messages/**/*.json';
var LANG_DIR = 'locales/';
var LANG_PATTERN = '';
var IGNORED = ['translations', 'data'];
program.option('-p, --pattern <value>', 'file pattern').option('-I, --ignore-files <value>', 'array of ignored files').option('-L, --lang-pattern <value>', 'pattern to look for files with languages').option('-l, --lang-dir <dir>', 'folder with languages');
var rootFolder = "".concat(process.cwd(), "/");
program.parse(process.argv);

if (program.ignoreFiles) {
  IGNORED = program.ignoreFiles.split(',');
}

if (program.pattern) {
  MESSAGES_PATTERN = program.pattern;
}

if (program.langDir) {
  LANG_DIR = program.langDir;
}

if (program.langPattern) {
  LANG_PATTERN = "".concat(LANG_DIR).concat(program.langPattern);
} else {
  LANG_PATTERN = "".concat(LANG_DIR, "/*.json");
} // Merge translated json files (es.json, fr.json, etc) into one object
// so that they can be merged with the eggregated 'en' object below


var mergedTranslations = globSync("".concat(rootFolder).concat(LANG_PATTERN)).map(function (filename) {
  var locale = last(filename.split('/')).split('.json')[0];

  if (!IGNORED.includes(locale)) {
    return _defineProperty({}, locale, JSON.parse(fs.readFileSync(filename, 'utf8')));
  }
}).reduce(function (acc, localeObj) {
  return _objectSpread(_objectSpread({}, acc), localeObj);
}, {}); // Aggregates the default messages that were extracted from the example app's
// React components via the React Intl Babel plugin. An error will be thrown if
// there are messages in different components that use the same `id`. The result
// is a flat collection of `id: message` pairs for the app's default locale.

var defaultMessages = globSync("".concat(rootFolder).concat(MESSAGES_PATTERN)).map(function (filename) {
  return fs.readFileSync(filename, 'utf8');
}).map(function (file) {
  return JSON.parse(file);
}).reduce(function (collection, descriptors) {
  descriptors.forEach(function (_ref2) {
    var id = _ref2.id,
        defaultMessage = _ref2.defaultMessage;

    if (collection.hasOwnProperty(id)) {
      throw new Error("Duplicate message id: ".concat(id));
    }

    collection[id] = defaultMessage;
  });
  return collection;
}, {}); // Create a new directory that we want to write the aggregate messages to

mkdirpSync("".concat(rootFolder).concat(LANG_DIR)); // Merge aggregated default messages with the translated json files and
// write the messages to this directory

fs.writeFileSync("".concat(rootFolder).concat(LANG_DIR, "data.json"), JSON.stringify(_objectSpread({
  en: defaultMessages || {}
}, mergedTranslations), null, 2));
fs.writeFileSync("".concat(rootFolder).concat(LANG_DIR, "translations.json"), JSON.stringify(_objectSpread({}, defaultMessages) || {}, null, 2));