"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _Breadcrumb = require("@patternfly/react-core/dist/js/components/Breadcrumb/Breadcrumb.js");

var _BreadcrumbItem = require("@patternfly/react-core/dist/js/components/Breadcrumb/BreadcrumbItem.js");

/* eslint-disable react/prop-types */

/**
 * @deprecated
 *
 * Breadcrumbs from FE component shouldn't be used anymore.
 *
 * Use <a href="https://www.patternfly.org/v4/components/breadcrumb" target="_blank">Breadcrumbs</a> from PF repository.
 */
var Breadcrumbs = function Breadcrumbs(_ref) {
  var items = _ref.items,
      current = _ref.current,
      className = _ref.className,
      onNavigate = _ref.onNavigate,
      props = (0, _objectWithoutProperties2["default"])(_ref, ["items", "current", "className", "onNavigate"]);
  console.warn('Breadcrumbs from FE component shouldn\'t be used anymore. \
Instead use https://patternfly-react.surge.sh/documentation/react/components/breadcrumb from PF repository.');
  return /*#__PURE__*/_react["default"].createElement(_Breadcrumb.Breadcrumb, (0, _extends2["default"])({
    className: (0, _classnames["default"])('ins-c-breadcrumbs', className)
  }, props), items.map(function (oneLink, key) {
    return /*#__PURE__*/_react["default"].createElement(_BreadcrumbItem.BreadcrumbItem, {
      key: key,
      "data-key": key
    }, /*#__PURE__*/_react["default"].createElement("a", {
      onClick: function onClick(event) {
        return onNavigate(event, oneLink.navigate, key);
      },
      "aria-label": oneLink.navigate
    }, oneLink.title));
  }), current && /*#__PURE__*/_react["default"].createElement(_BreadcrumbItem.BreadcrumbItem, {
    isActive: true
  }, " ", current, " "));
};

Breadcrumbs.propTypes = {
  items: _propTypes["default"].arrayOf(_propTypes["default"].shape({
    navigate: _propTypes["default"].any,
    title: _propTypes["default"].node
  })),
  current: _propTypes["default"].node,
  onNavigate: _propTypes["default"].func
};
Breadcrumbs.defaultProps = {
  items: [],
  current: null,
  onNavigate: Function.prototype,
  className: ''
};
var _default = Breadcrumbs;
exports["default"] = _default;