"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _Stack = require("@patternfly/react-core/dist/js/layouts/Stack/Stack.js");

var _StackItem = require("@patternfly/react-core/dist/js/layouts/Stack/StackItem.js");

var _reactIcons = require("@patternfly/react-icons/");

var _DefaultErrorMessage = _interopRequireDefault(require("./DefaultErrorMessage"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _Title = require("@patternfly/react-core/dist/js/components/Title/Title.js");

var _EmptyState = require("@patternfly/react-core/dist/js/components/EmptyState/EmptyState.js");

var _EmptyStateIcon = require("@patternfly/react-core/dist/js/components/EmptyState/EmptyStateIcon.js");

var _EmptyStateBody = require("@patternfly/react-core/dist/js/components/EmptyState/EmptyStateBody.js");

var _Button = require("@patternfly/react-core/dist/js/components/Button/Button.js");

require("./error-state.css");

var ErrorState = function ErrorState(_ref) {
  var errorTitle = _ref.errorTitle,
      errorDescription = _ref.errorDescription,
      props = (0, _objectWithoutProperties2["default"])(_ref, ["errorTitle", "errorDescription"]);
  return /*#__PURE__*/_react["default"].createElement(_EmptyState.EmptyState, (0, _extends2["default"])({
    variant: _EmptyState.EmptyStateVariant.large
  }, props, {
    className: "ins-c-error-state"
  }), /*#__PURE__*/_react["default"].createElement(_EmptyStateIcon.EmptyStateIcon, {
    icon: _reactIcons.ExclamationCircleIcon
  }), /*#__PURE__*/_react["default"].createElement(_Title.Title, {
    headingLevel: "h4",
    size: "lg"
  }, errorTitle), /*#__PURE__*/_react["default"].createElement(_EmptyStateBody.EmptyStateBody, null, /*#__PURE__*/_react["default"].createElement(_Stack.Stack, null, !errorDescription && /*#__PURE__*/_react["default"].createElement(_StackItem.StackItem, null, "There was a problem processing the request. Please try again."), /*#__PURE__*/_react["default"].createElement(_StackItem.StackItem, null, errorDescription || /*#__PURE__*/_react["default"].createElement(_DefaultErrorMessage["default"], null)))), document.referrer ? /*#__PURE__*/_react["default"].createElement(_Button.Button, {
    variant: "primary",
    onClick: function onClick() {
      return history.back();
    }
  }, "Return to last page") : /*#__PURE__*/_react["default"].createElement(_Button.Button, {
    variant: "primary",
    component: "a",
    href: ".",
    target: "_blank",
    rel: "noopener noreferrer"
  }, "Go to home page"));
};

ErrorState.propTypes = {
  errorTitle: _propTypes["default"].string,
  errorDescription: _propTypes["default"].string
};
ErrorState.defaultProps = {
  errorTitle: 'Something went wrong'
};
var _default = ErrorState;
exports["default"] = _default;