"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _EmptyState = require("@patternfly/react-core/dist/js/components/EmptyState/EmptyState.js");

var _EmptyStateIcon = require("@patternfly/react-core/dist/js/components/EmptyState/EmptyStateIcon.js");

var _EmptyStateBody = require("@patternfly/react-core/dist/js/components/EmptyState/EmptyStateBody.js");

var _Title = require("@patternfly/react-core/dist/js/components/Title/Title.js");

var _Button = require("@patternfly/react-core/dist/js/components/Button/Button.js");

var _disconnectedIcon = _interopRequireDefault(require("@patternfly/react-icons/dist/js/icons/disconnected-icon"));

var NotConnected = function NotConnected(_ref) {
  var titleText = _ref.titleText,
      bodyText = _ref.bodyText,
      buttonText = _ref.buttonText;
  return /*#__PURE__*/_react["default"].createElement(_EmptyState.EmptyState, null, /*#__PURE__*/_react["default"].createElement(_EmptyStateIcon.EmptyStateIcon, {
    icon: _disconnectedIcon["default"]
  }), /*#__PURE__*/_react["default"].createElement(_Title.Title, {
    headingLevel: "h5",
    size: "lg"
  }, titleText), /*#__PURE__*/_react["default"].createElement(_EmptyStateBody.EmptyStateBody, null, bodyText), /*#__PURE__*/_react["default"].createElement(_Button.Button, {
    variant: "primary",
    component: "a",
    href: "http://access.redhat.com/products/cloud_management_services_for_rhel#getstarted",
    target: "_blank",
    rel: "noopener noreferrer",
    className: "pf-u-mt-lg"
  }, buttonText));
};

NotConnected.propTypes = {
  titleText: _propTypes["default"].node,
  bodyText: _propTypes["default"].node,
  buttonText: _propTypes["default"].node
};
NotConnected.defaultProps = {
  titleText: 'This system is not yet connected to Insights',
  bodyText: 'Activate the Insights client for this system to get started.',
  buttonText: 'Learn about the Insights client'
};
var _default = NotConnected;
exports["default"] = _default;