import _extends from "@babel/runtime/helpers/extends";
import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _assertThisInitialized from "@babel/runtime/helpers/assertThisInitialized";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _defineProperty from "@babel/runtime/helpers/defineProperty";

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

import { Dropdown } from "@patternfly/react-core/dist/esm/components/Dropdown/Dropdown.js";
import { DropdownItem } from "@patternfly/react-core/dist/esm/components/Dropdown/DropdownItem.js";
import { DropdownToggle } from "@patternfly/react-core/dist/esm/components/Dropdown/DropdownToggle.js";
import { Tooltip } from "@patternfly/react-core/dist/esm/components/Tooltip/Tooltip.js";
import React, { Component } from 'react';
import ExportIcon from "@patternfly/react-icons/dist/esm/icons/export-icon";
import PropTypes from 'prop-types';

var DownloadButton = /*#__PURE__*/function (_Component) {
  _inherits(DownloadButton, _Component);

  var _super = _createSuper(DownloadButton);

  function DownloadButton() {
    var _this;

    _classCallCheck(this, DownloadButton);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    _defineProperty(_assertThisInitialized(_this), "state", {
      isOpen: false
    });

    _defineProperty(_assertThisInitialized(_this), "onToggle", function (isOpen) {
      _this.setState({
        isOpen: isOpen
      });
    });

    _defineProperty(_assertThisInitialized(_this), "onSelect", function () {
      _this.setState({
        isOpen: !_this.state.isOpen
      });
    });

    _defineProperty(_assertThisInitialized(_this), "conditionallyTooltip", function (children) {
      var tooltipText = _this.props.tooltipText;
      return /*#__PURE__*/React.createElement(React.Fragment, null, tooltipText ? /*#__PURE__*/React.createElement(Tooltip, {
        content: tooltipText
      }, children) : children);
    });

    return _this;
  }

  _createClass(DownloadButton, [{
    key: "render",
    value: function render() {
      var isOpen = this.state.isOpen;

      var _this$props = this.props,
          extraItems = _this$props.extraItems,
          onSelect = _this$props.onSelect,
          isDisabled = _this$props.isDisabled,
          tooltipText = _this$props.tooltipText,
          props = _objectWithoutProperties(_this$props, ["extraItems", "onSelect", "isDisabled", "tooltipText"]);

      return /*#__PURE__*/React.createElement(React.Fragment, null, this.conditionallyTooltip( /*#__PURE__*/React.createElement(Dropdown, _extends({}, props, {
        isPlain: true,
        onSelect: this.onSelect,
        toggle: /*#__PURE__*/React.createElement(DropdownToggle, {
          toggleIndicator: null,
          onToggle: this.onToggle,
          isDisabled: isDisabled,
          ouiaId: "toggle"
        }, /*#__PURE__*/React.createElement(ExportIcon, {
          size: "sm"
        })),
        isOpen: isOpen,
        dropdownItems: [/*#__PURE__*/React.createElement(DropdownItem, {
          key: "download-csv",
          ouiaId: "download-csv",
          component: "button",
          onClick: function onClick(event) {
            return onSelect(event, 'csv');
          },
          isDisabled: isDisabled
        }, "Export to CSV"), /*#__PURE__*/React.createElement(DropdownItem, {
          key: "download-json",
          ouiaId: "download-json",
          component: "button",
          onClick: function onClick(event) {
            return onSelect(event, 'json');
          },
          isDisabled: isDisabled
        }, "Export to JSON")].concat(_toConsumableArray(extraItems))
      }))));
    }
  }]);

  return DownloadButton;
}(Component);

DownloadButton.propTypes = {
  extraItems: PropTypes.arrayOf(PropTypes.node),
  tooltipText: PropTypes.node,
  onSelect: PropTypes.func,
  isDisabled: PropTypes.bool
};
DownloadButton.defaultProps = {
  extraItems: [],
  onSelect: function onSelect() {
    return undefined;
  }
};
export default DownloadButton;