import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import PropTypes from 'prop-types';
import React from 'react';
import classnames from 'classnames';
import Input from './Input';

var LabeledInput = function LabeledInput(_ref) {
  var _ref$type = _ref.type,
      type = _ref$type === void 0 ? 'text' : _ref$type,
      className = _ref.className,
      children = _ref.children,
      name = _ref.name,
      props = _objectWithoutProperties(_ref, ["type", "className", "children", "name"]);

  // Might generate ID which is not unique enough
  name = name || new Date().getTime() + Math.random().toString(36);
  return /*#__PURE__*/React.createElement("label", {
    className: classnames('pf-c-form__label', className),
    htmlFor: name
  }, /*#__PURE__*/React.createElement(Input, _extends({}, props, {
    type: type,
    name: name,
    id: name
  })), " ", children);
};

LabeledInput.propTypes = {
  type: PropTypes.string,
  className: PropTypes.string,
  children: PropTypes.node,
  name: PropTypes.string
};
export default LabeledInput;