import _extends from "@babel/runtime/helpers/extends";
import _asyncToGenerator from "@babel/runtime/helpers/asyncToGenerator";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _regeneratorRuntime from "@babel/runtime/regenerator";
import React, { useState, useEffect, Fragment } from 'react';
import PropTypes from 'prop-types';
import * as ReactRedux from 'react-redux';
import * as pfReactTable from '@patternfly/react-table';
import * as reactRouterDom from 'react-router-dom';
import { reactCore } from '@redhat-cloud-services/frontend-components-utilities/inventoryDependencies';
import { useStore } from 'react-redux';

var AsyncInventory = function AsyncInventory(_ref) {
  var fallback = _ref.fallback,
      onLoad = _ref.onLoad,
      innerRef = _ref.innerRef,
      component = _ref.component,
      props = _objectWithoutProperties(_ref, ["fallback", "onLoad", "innerRef", "component"]);

  var store = useStore();

  var _useState = useState(),
      _useState2 = _slicedToArray(_useState, 2),
      InvCmp = _useState2[0],
      setInvCmp = _useState2[1];

  useEffect(function () {
    _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee() {
      var _yield$insights$loadI, inventoryConnector, rest, _inventoryConnector, InvComponent;

      return _regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return insights.loadInventory({
                ReactRedux: ReactRedux,
                react: React,
                reactRouterDom: reactRouterDom,
                pfReactTable: pfReactTable,
                pfReact: reactCore
              });

            case 2:
              _yield$insights$loadI = _context.sent;
              inventoryConnector = _yield$insights$loadI.inventoryConnector;
              rest = _objectWithoutProperties(_yield$insights$loadI, ["inventoryConnector"]);
              onLoad(rest);
              _inventoryConnector = inventoryConnector(store), InvComponent = _inventoryConnector[component];
              setInvCmp(function () {
                return InvComponent;
              });

            case 8:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    }))();
  }, []);
  return InvCmp ? /*#__PURE__*/React.createElement(InvCmp, _extends({
    ref: innerRef
  }, props)) : fallback || /*#__PURE__*/React.createElement(Fragment, null);
};

AsyncInventory.propTypes = {
  fallback: PropTypes.any,
  onLoad: PropTypes.func,
  component: PropTypes.string,
  innerRef: PropTypes.object
};
AsyncInventory.defaultProps = {
  onLoad: function onLoad() {
    return undefined;
  },
  component: ''
};
export default AsyncInventory;