import React from 'react';
import propTypes from 'prop-types';
import classNames from 'classnames';
import { Title } from "@patternfly/react-core/dist/esm/components/Title/Title.js";
/**
 * This is the title section of the pageHeader
 */

var PageHeaderTitle = function PageHeaderTitle(_ref) {
  var className = _ref.className,
      title = _ref.title;
  var pageHeaderTitleClasses = classNames(className);
  return /*#__PURE__*/React.createElement(Title, {
    headingLevel: "h1",
    size: "2xl",
    className: pageHeaderTitleClasses,
    "widget-type": "InsightsPageHeaderTitle"
  }, " ", title, " ");
};

export default PageHeaderTitle;
PageHeaderTitle.propTypes = {
  title: propTypes.node.isRequired,
  className: propTypes.string
};