import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import React from 'react';
import PropTypes from 'prop-types';
import "../../TagCount/./tagCount.css";
import classNames from 'classnames';
import { Button } from "@patternfly/react-core/dist/esm/components/Button/Button.js";
import TagIcon from "@patternfly/react-icons/dist/esm/icons/tag-icon";
import "../../TagCount/./tagCount.css";

var TagCount = function TagCount(_ref) {
  var count = _ref.count,
      onTagClick = _ref.onTagClick,
      className = _ref.className,
      props = _objectWithoutProperties(_ref, ["count", "onTagClick", "className"]);

  return /*#__PURE__*/React.createElement(Button, _extends({}, props, {
    variant: "plain",
    isDisabled: !count,
    className: classNames('ins-c-tag-count', className),
    onClick: onTagClick
  }), /*#__PURE__*/React.createElement(TagIcon, {
    size: "md"
  }), /*#__PURE__*/React.createElement("span", {
    className: "ins-c-tag__text"
  }, count));
};

TagCount.propTypes = {
  count: PropTypes.number,
  onTagClick: PropTypes.func,
  className: PropTypes.string
};
TagCount.defaultProps = {
  onTagClick: function onTagClick() {
    return undefined;
  }
};
export default TagCount;