import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _assertThisInitialized from "@babel/runtime/helpers/assertThisInitialized";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

import React from 'react';
import propTypes from 'prop-types';
import classNames from 'classnames';
import { Button } from "@patternfly/react-core/dist/esm/components/Button/Button.js";
import { Stack } from "@patternfly/react-core/dist/esm/layouts/Stack/Stack.js";
import { StackItem } from "@patternfly/react-core/dist/esm/layouts/Stack/StackItem.js";
import "../../Truncate/./truncate.css";
import sanitizeHtml from 'sanitize-html';

var Truncate = /*#__PURE__*/function (_React$Component) {
  _inherits(Truncate, _React$Component);

  var _super = _createSuper(Truncate);

  function Truncate(props) {
    var _this;

    _classCallCheck(this, Truncate);

    _this = _super.call(this, props);
    _this.state = {
      showText: false
    };
    _this.toggleText = _this.toggleText.bind(_assertThisInitialized(_this));
    return _this;
  }

  _createClass(Truncate, [{
    key: "toggleText",
    value: function toggleText(event) {
      event && event.preventDefault();
      this.setState({
        showText: !this.state.showText
      });
    }
  }, {
    key: "dangerousHtml",
    value: function dangerousHtml(text) {
      return {
        __html: sanitizeHtml(text)
      };
    }
  }, {
    key: "render",
    value: function render() {
      var truncateClasses = classNames('ins-c-truncate', this.props.className, _defineProperty({}, "is-inline", this.props.inline), _defineProperty({}, "is-block", !this.props.inline));
      var trimmedText = this.props.text.substring(0, this.props.length);
      var textOverflow = this.props.text.length > this.props.length;
      var showText = this.state.showText;
      var expandButton = /*#__PURE__*/React.createElement(Button, {
        className: "ins-c-expand-button",
        variant: "link",
        onClick: this.toggleText
      }, this.props.expandText);
      var collapseButton = /*#__PURE__*/React.createElement(Button, {
        className: "ins-c-collapse-button",
        variant: "link",
        onClick: this.toggleText
      }, this.props.collapseText);

      if (this.props.inline) {
        return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement("span", {
          className: truncateClasses,
          "widget-type": "InsightsTruncateInline",
          dangerouslySetInnerHTML: this.dangerousHtml(showText === false ? "".concat(trimmedText).concat(textOverflow ? '...' : '') : this.props.text)
        }), textOverflow && (showText === false ? expandButton : collapseButton));
      } else {
        return /*#__PURE__*/React.createElement(Stack, {
          className: truncateClasses
        }, /*#__PURE__*/React.createElement(StackItem, null, /*#__PURE__*/React.createElement("span", {
          "widget-type": "InsightsTruncateBlock",
          dangerouslySetInnerHTML: this.dangerousHtml(showText === false ? "".concat(trimmedText).concat(textOverflow ? '...' : '') : this.props.text)
        })), textOverflow && /*#__PURE__*/React.createElement(StackItem, {
          className: this.props.spaceBetween && 'pf-u-mt-sm'
        }, showText === false ? expandButton : collapseButton));
      }
    }
  }]);

  return Truncate;
}(React.Component);

;
export default Truncate;
Truncate.propTypes = {
  className: propTypes.string,
  text: propTypes.string,
  length: propTypes.number,
  expandText: propTypes.string,
  collapseText: propTypes.string,
  inline: propTypes.bool,
  spaceBetween: propTypes.bool
};
Truncate.defaultProps = {
  length: 150,
  expandText: 'Read more',
  collapseText: 'Collapse',
  text: ''
};