import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _asyncToGenerator from "@babel/runtime/helpers/asyncToGenerator";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _wrapNativeSuper from "@babel/runtime/helpers/wrapNativeSuper";
import _regeneratorRuntime from "@babel/runtime/regenerator";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

import axios from 'axios';
import { configureScope, captureException } from '@sentry/browser';
export var HttpError = /*#__PURE__*/function (_Error) {
  _inherits(HttpError, _Error);

  var _super = _createSuper(HttpError);

  function HttpError(description) {
    var _this;

    _classCallCheck(this, HttpError);

    _this = _super.call(this, 'Error communicating with the server');
    _this.description = description;
    return _this;
  }

  return HttpError;
}( /*#__PURE__*/_wrapNativeSuper(Error));
export function authInterceptor(_x) {
  return _authInterceptor.apply(this, arguments);
}

function _authInterceptor() {
  _authInterceptor = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee(config) {
    return _regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            _context.next = 2;
            return window.insights.chrome.auth.getUser();

          case 2:
            return _context.abrupt("return", config);

          case 3:
          case "end":
            return _context.stop();
        }
      }
    }, _callee);
  }));
  return _authInterceptor.apply(this, arguments);
}

export function responseDataInterceptor(response) {
  if (response.data) {
    return response.data;
  }

  return response;
}
export function interceptor401(error) {
  if (error.response && error.response.status === 401) {
    window.insights.chrome.auth.logout();
    return false;
  }

  throw error;
}
export function interceptor500(error) {
  if (error.response && error.response.status >= 500 && error.response.status < 600) {
    configureScope(function (scope) {
      scope.setTag('request_id', error.response.req_id);
    });
  }

  throw error;
}
export function errorInterceptor(err) {
  if (!axios.isCancel(err)) {
    var requestId;

    try {
      var _errObject$response, _errObject$response$h;

      var errObject = _objectSpread({}, err);

      requestId = (_errObject$response = errObject.response) === null || _errObject$response === void 0 ? void 0 : (_errObject$response$h = _errObject$response.headers) === null || _errObject$response$h === void 0 ? void 0 : _errObject$response$h['x-rh-insights-request-id'];

      if (errObject.response && errObject.response.data) {
        throw _objectSpread(_objectSpread({}, errObject.response.data), {}, {
          statusText: errObject.response.statusText
        });
      }

      throw err;
    } catch (customError) {
      if (!requestId) {
        customError.sentryId = captureException(customError);
      }

      customError.requestId = requestId;
      throw customError;
    }
  }
}
export var instance = axios.create();
instance.interceptors.request.use(authInterceptor);
instance.interceptors.response.use(responseDataInterceptor);
instance.interceptors.response.use(null, interceptor401);
instance.interceptors.response.use(null, interceptor500);
instance.interceptors.response.use(null, errorInterceptor);
export default instance;