"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importDefault(require("react"));
var prop_types_1 = __importDefault(require("prop-types"));
var classnames_1 = __importDefault(require("classnames"));
var react_core_1 = require("@patternfly/react-core");
var Breadcrumbs = function (_a) {
    var items = _a.items, current = _a.current, className = _a.className, onNavigate = _a.onNavigate, props = __rest(_a, ["items", "current", "className", "onNavigate"]);
    console.warn("Breadcrumbs from FE component shouldn't be used anymore. \
Instead use https://patternfly-react.surge.sh/documentation/react/components/breadcrumb from PF repository.");
    return (react_1.default.createElement(react_core_1.Breadcrumb, __assign({ className: (0, classnames_1.default)('ins-c-breadcrumbs', className) }, props),
        items.map(function (oneLink, key) { return (react_1.default.createElement(react_core_1.BreadcrumbItem, { key: key, "data-key": key },
            react_1.default.createElement("a", { onClick: function (event) { return onNavigate(event, oneLink.navigate, key); }, "aria-label": oneLink.navigate }, oneLink.title))); }),
        current && react_1.default.createElement(react_core_1.BreadcrumbItem, { isActive: true },
            " ",
            current,
            " ")));
};
Breadcrumbs.propTypes = {
    items: prop_types_1.default.arrayOf(prop_types_1.default.shape({
        navigate: prop_types_1.default.any,
        title: prop_types_1.default.node,
    })),
    current: prop_types_1.default.node,
    onNavigate: prop_types_1.default.func,
};
Breadcrumbs.defaultProps = {
    items: [],
    current: null,
    onNavigate: Function.prototype,
    className: '',
};
exports.default = Breadcrumbs;
//# sourceMappingURL=Breadcrumbs.js.map