"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importDefault(require("react"));
var prop_types_1 = __importDefault(require("prop-types"));
var helper_1 = require("./helper");
function DateFormat(_a) {
    var date = _a.date, _b = _a.type, type = _b === void 0 ? 'relative' : _b, extraTitle = _a.extraTitle, _c = _a.tooltipProps, tooltipProps = _c === void 0 ? {} : _c;
    var dateObj = date instanceof Date ? date : new Date(date);
    var invalid = date === undefined || date === null || dateObj.toString() === 'Invalid Date';
    var dateType = invalid ? 'invalid' : type;
    return react_1.default.createElement(react_1.default.Fragment, null, (0, helper_1.dateByType)(dateType, tooltipProps, extraTitle)(dateObj));
}
exports.default = DateFormat;
DateFormat.propTypes = {
    date: prop_types_1.default.oneOfType([prop_types_1.default.instanceOf(Date), prop_types_1.default.string, prop_types_1.default.number]),
    type: prop_types_1.default.oneOf(['exact', 'onlyDate', 'relative']),
    extraTitle: prop_types_1.default.node,
    tooltipProps: prop_types_1.default.object,
};
//# sourceMappingURL=DateFormat.js.map