"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importDefault(require("react"));
var prop_types_1 = __importDefault(require("prop-types"));
var react_core_1 = require("@patternfly/react-core");
var classnames_1 = __importDefault(require("classnames"));
require("./filter-chips.css");
var FilterChips = function (_a) {
    var className = _a.className, filters = _a.filters, onDelete = _a.onDelete, deleteTitle = _a.deleteTitle, showDeleteButton = _a.showDeleteButton, onDeleteGroup = _a.onDeleteGroup;
    var groups = filters.filter(function (group) { return Object.prototype.hasOwnProperty.call(group, 'category'); });
    var groupedFilters = groups.map(function (group, groupKey) { return (react_1.default.createElement(react_core_1.ChipGroup, __assign({ key: "group_".concat(group.category), categoryName: String(group.category) || ' ' }, (onDeleteGroup && {
        isClosable: true,
        onClick: function (event) {
            event.stopPropagation();
            onDeleteGroup(event, [group], groups.filter(function (_item, key) { return key !== groupKey; }));
        },
    })), group.chips.map(function (chip) { return (react_1.default.createElement(react_core_1.Chip, { key: chip.name, onClick: function (event) {
            event.stopPropagation();
            onDelete(event, [__assign(__assign({}, group), { chips: [chip] })]);
        } },
        chip.name,
        chip.count && (react_1.default.createElement(react_core_1.Badge, { key: "chip_badge_".concat(chip.id), isRead: chip.isRead }, chip.count)))); }))); });
    var plainFilters = filters.filter(function (group) { return !Object.prototype.hasOwnProperty.call(group, 'category'); });
    return (react_1.default.createElement("span", { className: (0, classnames_1.default)(className, 'ins-c-chip-filters') },
        groupedFilters,
        plainFilters &&
            plainFilters.map(function (chip) { return (react_1.default.createElement(react_core_1.ChipGroup, { key: "group_plain_chip_".concat(chip.name) },
                react_1.default.createElement(react_core_1.Chip, { onClick: function (event) {
                        event.stopPropagation();
                        onDelete(event, [chip]);
                    } },
                    chip.name,
                    chip.count && (react_1.default.createElement(react_core_1.Badge, { key: "chip_badge_".concat(chip.id), isRead: chip.isRead }, chip.count))))); }),
        (showDeleteButton === true || (showDeleteButton === undefined && filters.length > 0)) && (react_1.default.createElement(react_core_1.Button, { variant: "link", ouiaId: "ClearFilters", onClick: function (event) { return onDelete(event, filters, true); } }, deleteTitle))));
};
FilterChips.propTypes = {
    className: prop_types_1.default.string,
    filters: prop_types_1.default.arrayOf(prop_types_1.default.oneOfType([
        prop_types_1.default.shape({
            category: prop_types_1.default.string.isRequired,
            chips: prop_types_1.default.arrayOf(prop_types_1.default.shape({
                name: prop_types_1.default.string.isRequired,
                isRead: prop_types_1.default.bool,
                count: prop_types_1.default.number,
            })).isRequired,
        }),
        prop_types_1.default.shape({
            name: prop_types_1.default.string.isRequired,
            isRead: prop_types_1.default.bool,
            count: prop_types_1.default.number,
        }),
    ])),
    onDelete: prop_types_1.default.func,
    onDeleteGroup: prop_types_1.default.func,
    deleteTitle: prop_types_1.default.node,
    showDeleteButton: prop_types_1.default.bool,
};
FilterChips.defaultProps = {
    filters: [],
    onDelete: function () { return undefined; },
    deleteTitle: 'Clear filters',
};
exports.default = FilterChips;
//# sourceMappingURL=FilterChips.js.map