import React from 'react';
export declare type Tag = {
    key: string;
    value: string;
};
declare type TagGroup = {
    count: number;
    tag: Tag;
};
export declare type GroupItem = {
    tagKey: string;
    tagValue: string;
    meta?: {
        tag: Tag;
    };
};
declare type Group = {
    isSelected: boolean;
    group: Record<string, unknown>;
    value?: string;
    item?: GroupItem;
};
export declare type GroupValue = {
    [key: string]: Group;
};
declare type ConstructValuesItem = {
    key: string;
    tagKey: string;
    value?: string;
    name: string;
    group: Record<string, unknown>;
};
export declare type AllTag = {
    name: React.ReactNode;
    type?: 'checkbox';
    tags: TagGroup[];
};
export declare function constructValues(groupValue: GroupValue, groupKey: string): ConstructValuesItem[];
interface MapGroupsItem {
    type: 'tags';
    key: string;
    category: any;
    [key: string]: ConstructValuesItem[] | 'tags' | string | any;
}
export declare function mapGroups(currSelection: {
    [key: string]: GroupValue;
}, valuesKey?: string): MapGroupsItem[];
export declare function constructGroups(allTags: AllTag[], item?: string): {
    label: React.ReactNode;
    value: React.ReactNode;
    type: "checkbox";
    items: {
        className: string;
        label: JSX.Element;
        meta: {
            count: number;
            tag: {
                key: string;
                value: string;
            };
        };
        id: string;
        tagKey: string;
        value: string;
        tagValue: string;
    }[];
}[];
export {};
