"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.constructGroups = exports.mapGroups = exports.constructValues = void 0;
var react_1 = __importDefault(require("react"));
var react_core_1 = require("@patternfly/react-core");
function constructValues(groupValue, groupKey) {
    return Object.entries(groupValue || {}).reduce(function (acc, curr) {
        var _a;
        var key = curr[0], _b = curr[1], isSelected = _b.isSelected, group = _b.group, value = _b.value, item = _b.item;
        if (isSelected) {
            var _c = ((_a = item === null || item === void 0 ? void 0 : item.meta) === null || _a === void 0 ? void 0 : _a.tag) || {
                key: (item === null || item === void 0 ? void 0 : item.tagKey) || groupKey,
                value: value || (item === null || item === void 0 ? void 0 : item.tagValue),
            }, tagKey = _c.key, tagValue = _c.value;
            return __spreadArray(__spreadArray([], acc, true), [
                {
                    key: key,
                    tagKey: tagKey,
                    value: tagValue,
                    name: "".concat(tagKey).concat(tagValue ? "=".concat(tagValue) : ''),
                    group: __assign({ value: groupKey }, group),
                },
            ], false);
        }
        return acc;
    }, []);
}
exports.constructValues = constructValues;
function mapGroups(currSelection, valuesKey) {
    if (valuesKey === void 0) { valuesKey = 'values'; }
    return Object.entries(currSelection || {}).reduce(function (acc, _a) {
        var _b;
        var _c, _d, _e, _f;
        var groupKey = _a[0], groupValue = _a[1];
        var values = constructValues(groupValue, groupKey);
        if (values.length > 0) {
            return __spreadArray(__spreadArray([], acc, true), [
                (_b = {
                        type: 'tags',
                        key: groupKey,
                        category: ((_d = (_c = values[0]) === null || _c === void 0 ? void 0 : _c.group) === null || _d === void 0 ? void 0 : _d.value) || ((_f = (_e = values[0]) === null || _e === void 0 ? void 0 : _e.group) === null || _f === void 0 ? void 0 : _f.label)
                    },
                    _b[valuesKey] = values,
                    _b),
            ], false);
        }
        return acc;
    }, []);
}
exports.mapGroups = mapGroups;
function constructGroups(allTags, item) {
    if (item === void 0) { item = 'item'; }
    return allTags.map(function (_a) {
        var name = _a.name, tags = _a.tags, _b = _a.type, type = _b === void 0 ? 'checkbox' : _b, rest = __rest(_a, ["name", "tags", "type"]);
        return (__assign(__assign({}, rest), { label: name, value: name, type: type, items: tags.map(function (_a) {
                var count = _a.count, _b = _a.tag, tagKey = _b.key, value = _b.value;
                var tagText = "".concat(tagKey).concat(value ? "=".concat(value) : '');
                return {
                    className: 'ins-c-tagfilter__option',
                    label: (react_1.default.createElement(react_1.default.Fragment, null,
                        react_1.default.createElement(react_core_1.Tooltip, { content: tagText },
                            react_1.default.createElement("div", { className: "ins-c-tagfilter__option-value" }, tagText)),
                        count !== undefined && (react_1.default.createElement(react_core_1.Tooltip, { position: "right", enableFlip: true, content: "Applicable to ".concat(count, " ").concat(item).concat(count === 1 ? '' : 's', ".") },
                            react_1.default.createElement(react_core_1.Badge, { isRead: count <= 0 }, count))))),
                    meta: {
                        count: count,
                        tag: {
                            key: tagKey,
                            value: value,
                        },
                    },
                    id: "".concat(tagKey, "-").concat(value),
                    tagKey: tagKey,
                    value: tagText,
                    tagValue: value,
                };
            }) }));
    });
}
exports.constructGroups = constructGroups;
//# sourceMappingURL=constants.js.map