"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importStar(require("react"));
var react_core_1 = require("@patternfly/react-core");
var react_core_2 = require("@patternfly/react-core/");
var prop_types_1 = __importDefault(require("prop-types"));
var FilterInput_js_1 = __importDefault(require("./FilterInput.js"));
require("./filter-dropdown.css");
var FilterDropdown = (function (_super) {
    __extends(FilterDropdown, _super);
    function FilterDropdown() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.state = {
            isOpen: false,
            ouiaStateId: (0, react_core_2.getDefaultOUIAId)('RHI/FilterDropdown'),
        };
        _this.addRemoveFilters = function (selectedValue, filterName, type, isChecked) {
            switch (type) {
                case 'checkbox':
                    isChecked ? _this.props.addFilter(filterName, selectedValue, type) : _this.props.removeFilter(filterName, selectedValue);
                    break;
                case 'radio':
                    _this.props.addFilter(filterName, selectedValue, type);
                    break;
            }
        };
        _this.onToggle = function (isOpen) {
            _this.setState({
                isOpen: isOpen,
            });
        };
        return _this;
    }
    FilterDropdown.prototype.render = function () {
        var _this = this;
        var _a = this.props, hideCategories = _a.hideCategories, filters = _a.filters, filterCategories = _a.filterCategories, label = _a.label, ouiaId = _a.ouiaId, ouiaSafe = _a.ouiaSafe;
        var _b = this.state, isOpen = _b.isOpen, ouiaStateId = _b.ouiaStateId;
        var ouiaFinalId = ouiaId !== undefined ? ouiaId : ouiaStateId;
        return (react_1.default.createElement(react_core_1.Dropdown, { className: "ins-c-filter__dropdown", onSelect: this.onSelect, toggle: react_1.default.createElement(react_core_1.DropdownToggle, { ouiaId: ouiaFinalId, ouiaSafe: ouiaSafe, onToggle: this.onToggle }, label), isOpen: isOpen, ouiaId: ouiaFinalId, ouiaSafe: ouiaSafe },
            react_1.default.createElement("div", { className: "pf-c-dropdown__menu-item" }, filterCategories.map(function (data, index) {
                return !hideCategories.includes(data.urlParam) && (react_1.default.createElement(react_core_1.Level, { key: "".concat(data.urlParam).concat(index) },
                    data.title,
                    data.values.map(function (item, key) { return (react_1.default.createElement(FilterInput_js_1.default, { key: "check".concat(index).concat(key), "aria-label": item.label, id: "".concat(data.urlParam).concat(key), label: item.label, addRemoveFilters: _this.addRemoveFilters, param: data.urlParam, type: data.type, value: item.value, filters: filters })); }),
                    index !== filterCategories.length - 1 && react_1.default.createElement("br", null)));
            }))));
    };
    return FilterDropdown;
}(react_1.Component));
FilterDropdown.propTypes = {
    addFilter: prop_types_1.default.func,
    removeFilter: prop_types_1.default.func,
    hideCategories: prop_types_1.default.array,
    filters: prop_types_1.default.object,
    filterCategories: prop_types_1.default.arrayOf(prop_types_1.default.shape({
        title: prop_types_1.default.string,
        type: prop_types_1.default.type,
        urlParam: prop_types_1.default.string,
        values: prop_types_1.default.arrayOf(prop_types_1.default.shape({
            label: prop_types_1.default.node,
            value: prop_types_1.default.any,
        })),
    })),
    label: prop_types_1.default.oneOfType([prop_types_1.default.string, prop_types_1.default.node]),
    ouiaId: prop_types_1.default.string,
    ouiaSafe: prop_types_1.default.bool,
};
FilterDropdown.defaultProps = {
    addFilter: Function.prototype,
    removeFilter: Function.prototype,
    hideCategories: [],
    filters: {},
    label: 'Filters',
    ouiaSafe: true,
};
exports.default = FilterDropdown;
//# sourceMappingURL=FilterDropdown.js.map