"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importDefault(require("react"));
var prop_types_1 = __importDefault(require("prop-types"));
var react_core_1 = require("@patternfly/react-core");
var react_icons_1 = require("@patternfly/react-icons");
var NotConnected = function (_a) {
    var titleText = _a.titleText, bodyText = _a.bodyText, buttonText = _a.buttonText;
    return (react_1.default.createElement(react_core_1.EmptyState, null,
        react_1.default.createElement(react_core_1.EmptyStateIcon, { icon: react_icons_1.DisconnectedIcon }),
        react_1.default.createElement(react_core_1.Title, { headingLevel: "h5", size: "lg" }, titleText),
        react_1.default.createElement(react_core_1.EmptyStateBody, null, bodyText),
        react_1.default.createElement(react_core_1.Button, { variant: "primary", component: "a", href: "http://access.redhat.com/products/cloud_management_services_for_rhel#getstarted", target: "_blank", rel: "noopener noreferrer", className: "pf-u-mt-lg" }, buttonText)));
};
NotConnected.propTypes = {
    titleText: prop_types_1.default.node,
    bodyText: prop_types_1.default.node,
    buttonText: prop_types_1.default.node,
};
NotConnected.defaultProps = {
    titleText: 'This system isn’t connected to Insights yet',
    bodyText: 'To get started, activate the Insights client for this system.',
    buttonText: 'Learn how to activate the Insights client',
};
exports.default = NotConnected;
//# sourceMappingURL=NotConnected.js.map