"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importStar(require("react"));
var prop_types_1 = __importDefault(require("prop-types"));
var react_core_1 = require("@patternfly/react-core");
var Input_1 = require("../Input");
var react_icons_1 = require("@patternfly/react-icons");
require("./simple-table-filter.css");
var SimpleFilter = (function (_super) {
    __extends(SimpleFilter, _super);
    function SimpleFilter() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.state = {
            activeFilter: '',
            isOpen: false,
        };
        _this.onToggle = function (isOpen) {
            _this.setState({
                isOpen: isOpen,
            });
        };
        _this.onInputChange = function (event) {
            _this.setState({ activeFilter: event.target.value });
            _this.props.onFilterChange(event.target.value, _this.state.selected);
        };
        _this.onFilterSubmit = function () {
            _this.props.onButtonClick(_this.state.activeFilter, _this.state.selected);
        };
        _this.onFilterSelect = function (event, oneItem) {
            _this.setState({
                selected: oneItem,
            });
            _this.props.onOptionSelect(event, oneItem);
        };
        _this.onSelect = function () {
            _this.setState({
                isOpen: false,
            });
        };
        return _this;
    }
    SimpleFilter.prototype.render = function () {
        var _this = this;
        var _a = this.props, placeholder = _a.placeholder, buttonTitle = _a.buttonTitle, className = _a.className, onButtonClick = _a.onButtonClick, onOptionSelect = _a.onOptionSelect, onFilterChange = _a.onFilterChange, options = _a.options, searchIcon = _a.searchIcon, widgetId = _a.widgetId, props = __rest(_a, ["placeholder", "buttonTitle", "className", "onButtonClick", "onOptionSelect", "onFilterChange", "options", "searchIcon", "widgetId"]);
        var _b = this.state, isOpen = _b.isOpen, selected = _b.selected;
        var dropdownItems = options &&
            options.items &&
            options.items.map(function (oneItem) { return (react_1.default.createElement(react_core_1.DropdownItem, { component: "button", key: oneItem.value, onClick: function (event) { return _this.onFilterSelect(event, oneItem); }, "data-key": oneItem.value }, oneItem.title)); });
        return (react_1.default.createElement("div", __assign({ className: "pf-c-input-group ins-c-filter ".concat(!buttonTitle ? 'ins-u-no-title' : '', " ").concat(className) }, props),
            options && (react_1.default.createElement(react_core_1.Dropdown, { onSelect: this.onSelect, isOpen: isOpen, toggle: react_1.default.createElement(react_core_1.DropdownToggle, { onToggle: this.onToggle }, (selected && selected.title) || options.title || 'Dropdown'), dropdownItems: dropdownItems })),
            react_1.default.createElement(Input_1.Input, { placeholder: placeholder, onKeyPress: function (event) { return event.key === 'Enter' && _this.onInputChange(event); }, "widget-id": widgetId, onChange: this.onInputChange }),
            !buttonTitle && searchIcon && react_1.default.createElement(react_icons_1.SearchIcon, { size: "sm", className: "ins-c-search-icon" }),
            buttonTitle && (react_1.default.createElement(react_core_1.Button, { variant: react_core_1.ButtonVariant.secondary, action: "filter", onClick: this.onFilterSubmit }, buttonTitle))));
    };
    return SimpleFilter;
}(react_1.Component));
SimpleFilter.propTypes = {
    widgetId: prop_types_1.default.string,
    buttonTitle: prop_types_1.default.string,
    placeholder: prop_types_1.default.string,
    className: prop_types_1.default.string,
    options: prop_types_1.default.shape({
        title: prop_types_1.default.string,
        items: prop_types_1.default.arrayOf(prop_types_1.default.shape({
            value: prop_types_1.default.string,
            title: prop_types_1.default.string,
        })),
    }),
    onButtonClick: prop_types_1.default.func,
    onFilterChange: prop_types_1.default.func,
    onOptionSelect: prop_types_1.default.func,
    searchIcon: prop_types_1.default.bool,
};
SimpleFilter.defaultProps = {
    className: '',
    placeholder: 'Search items',
    buttonTitle: 'Filter',
    onButtonClick: function () { return undefined; },
    onFilterChange: function () { return undefined; },
    onOptionSelect: function () { return undefined; },
    searchIcon: true,
};
exports.default = SimpleFilter;
//# sourceMappingURL=SimpleTableFilter.js.map