"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importStar(require("react"));
var prop_types_1 = __importDefault(require("prop-types"));
var classnames_1 = __importDefault(require("classnames"));
var react_core_1 = require("@patternfly/react-core");
var sanitize_html_1 = __importDefault(require("sanitize-html"));
require("./truncate.css");
var dangerousHtml = function (html) { return ({ __html: (0, sanitize_html_1.default)(html) }); };
var Truncate = function (_a) {
    var _b, _c;
    var _d = _a.text, text = _d === void 0 ? '' : _d, _e = _a.length, length = _e === void 0 ? 150 : _e, _f = _a.expandText, expandText = _f === void 0 ? 'Read more' : _f, _g = _a.hideExpandText, hideExpandText = _g === void 0 ? false : _g, _h = _a.expandOnMouseOver, expandOnMouseOver = _h === void 0 ? false : _h, _j = _a.collapseText, collapseText = _j === void 0 ? 'Collapse' : _j, className = _a.className, inline = _a.inline, spaceBetween = _a.spaceBetween;
    var truncateClasses = (0, classnames_1.default)('ins-c-truncate', className, (_b = {}, _b["is-inline"] = inline, _b), (_c = {}, _c["is-block"] = !inline, _c));
    var trimmedText = text.substring(0, length);
    var textOverflow = text.length > length;
    var _k = (0, react_1.useState)(false), showText = _k[0], setShowText = _k[1];
    var toggleText = function (event) {
        event && event.preventDefault();
        setShowText(!showText);
    };
    var expandButton = (react_1.default.createElement(react_core_1.Button, { className: "ins-c-expand-button", variant: "link", onClick: toggleText }, expandText));
    var collapseButton = (react_1.default.createElement(react_core_1.Button, { className: "ins-c-collapse-button", variant: "link", onClick: toggleText }, collapseText));
    var textWithOverflow = showText === false ? "".concat(trimmedText).concat(textOverflow ? '...' : '') : text;
    var html = dangerousHtml(textWithOverflow);
    var mouseOverHandler = expandOnMouseOver && {
        onMouseEnter: function () { return setShowText(true); },
        onMouseLeave: function () { return setShowText(false); },
    };
    return inline ? (react_1.default.createElement(react_1.default.Fragment, null,
        react_1.default.createElement("span", __assign({ className: truncateClasses, "widget-type": "InsightsTruncateInline", dangerouslySetInnerHTML: html }, mouseOverHandler)),
        !hideExpandText && textOverflow && (showText === false ? expandButton : collapseButton))) : (react_1.default.createElement(react_core_1.Stack, { className: truncateClasses },
        react_1.default.createElement(react_core_1.StackItem, __assign({}, mouseOverHandler),
            react_1.default.createElement("span", { "widget-type": "InsightsTruncateBlock", dangerouslySetInnerHTML: html })),
        !hideExpandText && textOverflow && (react_1.default.createElement(react_core_1.StackItem, { className: spaceBetween && 'pf-u-mt-sm' }, showText === false ? expandButton : collapseButton))));
};
Truncate.propTypes = {
    className: prop_types_1.default.string,
    text: prop_types_1.default.string,
    length: prop_types_1.default.number,
    expandText: prop_types_1.default.string,
    collapseText: prop_types_1.default.string,
    inline: prop_types_1.default.bool,
    spaceBetween: prop_types_1.default.bool,
    hideExpandText: prop_types_1.default.bool,
    expandOnMouseOver: prop_types_1.default.bool,
};
exports.default = Truncate;
//# sourceMappingURL=Truncate.js.map