var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import React from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';
import { Breadcrumb, BreadcrumbItem } from '@patternfly/react-core';
var Breadcrumbs = function (_a) {
    var items = _a.items, current = _a.current, className = _a.className, onNavigate = _a.onNavigate, props = __rest(_a, ["items", "current", "className", "onNavigate"]);
    console.warn("Breadcrumbs from FE component shouldn't be used anymore. \
Instead use https://patternfly-react.surge.sh/documentation/react/components/breadcrumb from PF repository.");
    return (React.createElement(Breadcrumb, __assign({ className: classnames('ins-c-breadcrumbs', className) }, props),
        items.map(function (oneLink, key) { return (React.createElement(BreadcrumbItem, { key: key, "data-key": key },
            React.createElement("a", { onClick: function (event) { return onNavigate(event, oneLink.navigate, key); }, "aria-label": oneLink.navigate }, oneLink.title))); }),
        current && React.createElement(BreadcrumbItem, { isActive: true },
            " ",
            current,
            " ")));
};
Breadcrumbs.propTypes = {
    items: PropTypes.arrayOf(PropTypes.shape({
        navigate: PropTypes.any,
        title: PropTypes.node,
    })),
    current: PropTypes.node,
    onNavigate: PropTypes.func,
};
Breadcrumbs.defaultProps = {
    items: [],
    current: null,
    onNavigate: Function.prototype,
    className: '',
};
export default Breadcrumbs;
//# sourceMappingURL=Breadcrumbs.js.map