import React from 'react';
import PropTypes from 'prop-types';
import { dateByType } from './helper';
export default function DateFormat(_a) {
    var date = _a.date, _b = _a.type, type = _b === void 0 ? 'relative' : _b, extraTitle = _a.extraTitle, _c = _a.tooltipProps, tooltipProps = _c === void 0 ? {} : _c;
    var dateObj = date instanceof Date ? date : new Date(date);
    var invalid = date === undefined || date === null || dateObj.toString() === 'Invalid Date';
    var dateType = invalid ? 'invalid' : type;
    return React.createElement(React.Fragment, null, dateByType(dateType, tooltipProps, extraTitle)(dateObj));
}
DateFormat.propTypes = {
    date: PropTypes.oneOfType([PropTypes.instanceOf(Date), PropTypes.string, PropTypes.number]),
    type: PropTypes.oneOf(['exact', 'onlyDate', 'relative']),
    extraTitle: PropTypes.node,
    tooltipProps: PropTypes.object,
};
//# sourceMappingURL=DateFormat.js.map