var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
import React, { useState, useEffect } from 'react';
import { constructGroups, mapGroups } from './constants';
import { Spinner } from '@patternfly/react-core';
import './tagFilterHook.css';
export var tagsFilterState = { tagsFilter: {} };
export var TAGS_FILTER = 'TAGS_FILTER';
export var tagsFilterReducer = function (_state, _a) {
    var type = _a.type, payload = _a.payload;
    return (__assign({}, (type === TAGS_FILTER && {
        tagsFilter: payload,
    })));
};
export var useTagsFilter = function (allTags, loaded, additionalTagsCount, onShowMoreClick, _a, itemText, showMoreTitle) {
    if (allTags === void 0) { allTags = []; }
    if (loaded === void 0) { loaded = false; }
    if (additionalTagsCount === void 0) { additionalTagsCount = 0; }
    var _b = _a === void 0 ? [tagsFilterState] : _a, globalState = _b[0], dispatch = _b[1];
    if (itemText === void 0) { itemText = 'item'; }
    var _c = useState({
        allTags: [],
        loaded: false,
        additionalTagsCount: 0,
    }), state = _c[0], setState = _c[1];
    useEffect(function () {
        setState(function () { return ({
            allTags: allTags,
            loaded: loaded,
            additionalTagsCount: additionalTagsCount,
        }); });
    }, [loaded]);
    var _d = useState({}), selectedStateTags = _d[0], setStateValue = _d[1];
    var selectedTags = dispatch ? globalState.tagsFilter : selectedStateTags;
    var setValue = dispatch ? function (newValue) { return dispatch({ type: TAGS_FILTER, payload: newValue }); } : setStateValue;
    var _f = useState(''), filterTagsBy = _f[0], seFilterTagsBy = _f[1];
    var filter = __assign(__assign({ className: 'ins-c-tagfilter', onFilter: function (value) { return seFilterTagsBy(value); }, filterBy: filterTagsBy, onChange: function (_e, newSelection, group, item, groupKey, itemKey) {
            if (item.meta) {
                var isSelected = !!newSelection[groupKey][itemKey];
                newSelection[groupKey][itemKey] = {
                    isSelected: isSelected,
                    group: group,
                    item: item,
                };
                setValue(newSelection);
            }
        }, selected: selectedTags }, (additionalTagsCount && {
        onShowMore: function () {
            var props = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                props[_i] = arguments[_i];
            }
            return onShowMoreClick && onShowMoreClick.apply(void 0, props);
        },
        showMoreTitle: showMoreTitle || "".concat(state.additionalTagsCount, " more tags available"),
    })), (loaded && allTags.length > 0
        ? {
            groups: __spreadArray([], constructGroups(allTags, itemText), true),
        }
        : {
            value: '',
            items: [
                {
                    value: '',
                    label: !state.loaded ? (React.createElement("span", { key: "no-tags-tooltip" },
                        ' ',
                        React.createElement(Spinner, { size: "md" }),
                        ' ')) : (React.createElement("div", { className: "ins-c-tagfilter__no-tags" }, " No tags available ")),
                    isDisabled: true,
                    className: 'ins-c-tagfilter__tail',
                },
            ],
        }));
    return {
        filter: filter,
        chips: mapGroups(selectedTags, 'chips'),
        selectedTags: selectedTags,
        setValue: setValue,
        filterTagsBy: filterTagsBy,
        seFilterTagsBy: seFilterTagsBy,
    };
};
//# sourceMappingURL=tagFilterHook.js.map