var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import PropTypes from 'prop-types';
import React from 'react';
import classnames from 'classnames';
import { useOUIAId } from '@patternfly/react-core/';
var checkTypes = ['checkbox', 'radio'];
var Input = function (_a) {
    var _b = _a.type, type = _b === void 0 ? 'text' : _b, _c = _a.ariaLabel, ariaLabel = _c === void 0 ? type : _c, className = _a.className, ouiaId = _a.ouiaId, ouiaSafe = _a.ouiaSafe, props = __rest(_a, ["type", "ariaLabel", "className", "ouiaId", "ouiaSafe"]);
    var classes = checkTypes.indexOf(type) !== -1 ? 'pf-c-check' : 'pf-c-form-control';
    var ouiaComponentType = 'RHI/Input';
    var ouiaFinalId = useOUIAId(ouiaComponentType, ouiaId, ouiaSafe);
    return (React.createElement("input", __assign({}, props, { "data-ouia-component-type": ouiaComponentType, "data-ouia-component-id": ouiaFinalId, "data-ouia-safe": ouiaSafe, type: type, "aria-label": ariaLabel, className: classnames(classes, className) })));
};
Input.propTypes = {
    type: PropTypes.string,
    className: PropTypes.string,
    ariaLabel: PropTypes.string,
    ouiaId: PropTypes.string,
    ouiaSafe: PropTypes.bool,
};
Input.defaultProps = {
    ouiaSafe: true,
};
export default Input;
//# sourceMappingURL=Input.js.map