var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import React, { Suspense } from 'react';
import PropTypes from 'prop-types';
import { ScalprumComponent } from '@scalprum/react-core';
import { useHistory } from 'react-router-dom';
import { useStore } from 'react-redux';
import { Bullseye, Spinner } from '@patternfly/react-core';
import InventoryLoadError from './InventoryLoadError';
import classNames from 'classnames';
var BaseTagWithDialog = function (props) {
    var history = useHistory();
    var store = useStore();
    var Cmp = props.component;
    return (React.createElement(Cmp, { className: classNames(props.className, 'inventory') },
        React.createElement(Suspense, { fallback: props.fallback },
            React.createElement(ScalprumComponent, __assign({ history: history, store: store, appName: "inventory", module: "./TagWithDialog", scope: "inventory", ErrorComponent: React.createElement(InventoryLoadError, __assign({ component: "InventoryDetailHead", history: history, store: store }, props)), ref: props.innerRef }, props)))));
};
BaseTagWithDialog.propTypes = {
    fallback: PropTypes.node,
    innerRef: PropTypes.object,
    component: PropTypes.string,
    className: PropTypes.string,
};
var TagWithDialog = React.forwardRef(function (props, ref) { return React.createElement(BaseTagWithDialog, __assign({ innerRef: ref }, props)); });
TagWithDialog.propTypes = {
    fallback: PropTypes.node,
    component: PropTypes.string,
    className: PropTypes.string,
};
TagWithDialog.defaultProps = {
    fallback: (React.createElement(Bullseye, { className: "pf-u-p-lg" },
        React.createElement(Spinner, { size: "xl" }))),
    component: 'section',
};
export default TagWithDialog;
//# sourceMappingURL=TagWithDialog.js.map