var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import React from 'react';
import classNames from 'classnames';
import { DarkContext } from '../Dark';
import './page-header.css';
var PageHeader = function (_a) {
    var className = _a.className, children = _a.children, props = __rest(_a, ["className", "children"]);
    var pageHeaderClasses = classNames(className, 'pf-l-page-header', 'pf-c-page-header', 'pf-l-page__main-section', 'pf-c-page__main-section');
    return (React.createElement(DarkContext.Consumer, null, function (theme) {
        var _a, _b;
        if (theme === void 0) { theme = 'light'; }
        var themeClasses = classNames((_a = {}, _a["pf-m-".concat(theme, "-200")] = theme === 'dark', _a), (_b = {}, _b["pf-m-light"] = theme === 'light', _b));
        return (React.createElement("section", __assign({}, props, { className: "".concat(pageHeaderClasses, " ").concat(themeClasses), "widget-type": "InsightsPageHeader" }), children));
    }));
};
export default PageHeader;
//# sourceMappingURL=PageHeader.js.map