var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
import React from 'react';
import { RowSelectVariant, Table, TableHeader, TableBody } from '@patternfly/react-table';
import { Skeleton, SkeletonSize } from '../Skeleton';
import classNames from 'classnames';
import PropTypes from 'prop-types';
import './SkeletonTable.css';
var SkeletonTable = (function (_super) {
    __extends(SkeletonTable, _super);
    function SkeletonTable() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.createColumns = function () {
            var _a = _this.props, colSize = _a.colSize, isDark = _a.isDark;
            return __spreadArray([], Array(colSize), true).map(function () { return ({ title: React.createElement(Skeleton, { isDark: isDark, size: SkeletonSize.sm }) }); });
        };
        _this.getColumns = function () {
            var _a = _this.props, paddingColumnSize = _a.paddingColumnSize, columns = _a.columns;
            return _this.newArray(paddingColumnSize)
                .map(function () { return ''; })
                .concat(columns || _this.createColumns());
        };
        _this.createRows = function () {
            var _a = _this.props, colSize = _a.colSize, rowSize = _a.rowSize, columns = _a.columns, paddingColumnSize = _a.paddingColumnSize, isDark = _a.isDark;
            var numberOfCols = columns ? columns.length : colSize;
            return _this.newArray(rowSize).map(function () { return ({
                disableSelection: true,
                cells: _this.newArray(paddingColumnSize)
                    .map(function () { return ''; })
                    .concat(_this.newArray(numberOfCols).map(function () { return ({ title: React.createElement(Skeleton, { isDark: isDark, size: SkeletonSize.md }) }); })),
            }); });
        };
        _this.selectVariant = function () {
            var hasRadio = _this.props.hasRadio;
            return hasRadio ? (RowSelectVariant === null || RowSelectVariant === void 0 ? void 0 : RowSelectVariant.radio) || 'radio' : (RowSelectVariant === null || RowSelectVariant === void 0 ? void 0 : RowSelectVariant.checkbox) || 'checkbox';
        };
        _this.newArray = function (size) { return __spreadArray([], Array(size), true); };
        return _this;
    }
    SkeletonTable.prototype.render = function () {
        var _a = this.props, canSelectAll = _a.canSelectAll, isSelectable = _a.isSelectable, sortBy = _a.sortBy, variant = _a.variant, isDark = _a.isDark;
        return (React.createElement(Table, { className: classNames({
                'ins-c-skeleton-table__dark': isDark,
            }), cells: this.getColumns(), rows: this.createRows(), sortBy: sortBy, "aria-label": "Loading", onSelect: isSelectable, selectVariant: isSelectable ? this.selectVariant() : null, canSelectAll: canSelectAll, variant: variant },
            React.createElement(TableHeader, null),
            React.createElement(TableBody, null)));
    };
    return SkeletonTable;
}(React.Component));
SkeletonTable.propTypes = {
    colSize: PropTypes.number,
    rowSize: PropTypes.number,
    columns: PropTypes.array,
    paddingColumnSize: PropTypes.number,
    sortBy: PropTypes.shape({
        index: PropTypes.number,
        direction: PropTypes.oneOf(['asc', 'desc']),
    }),
    isSelectable: PropTypes.bool,
    canSelectAll: PropTypes.bool,
    hasRadio: PropTypes.bool,
    variant: PropTypes.string,
    isDark: PropTypes.bool,
};
SkeletonTable.defaultProps = {
    rowSize: 0,
    paddingColumnSize: 0,
    canSelectAll: false,
    isSelectable: false,
    hasRadio: false,
    variant: null,
    isDark: false,
};
export default SkeletonTable;
//# sourceMappingURL=SkeletonTable.js.map