var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
import React, { Fragment } from 'react';
import { Pagination, Bullseye, EmptyState, EmptyStateVariant, Title, EmptyStateBody } from '@patternfly/react-core';
import { PropTypes } from 'prop-types';
import { Table, TableHeader, TableBody } from '@patternfly/react-table';
import { EmptyTable } from '../EmptyTable';
import { TableToolbar } from '../TableToolbar';
import { PrimaryToolbar } from '../PrimaryToolbar';
import { Skeleton } from '../Skeleton';
import { SkeletonTable } from '../SkeletonTable';
var TableWithFilter = function (_a) {
    var rows = _a.rows, onSelect = _a.onSelect, selected = _a.selected, onUpdateData = _a.onUpdateData, pagination = _a.pagination, loaded = _a.loaded, calculateChecked = _a.calculateChecked, unique = _a.unique, filters = _a.filters, primaryToolbarProps = _a.primaryToolbarProps, children = _a.children, title = _a.title, systemName = _a.systemName, columns = _a.columns, tableProps = _a.tableProps, entityName = _a.entityName, bulkSelect = _a.bulkSelect;
    var onRowSelect = function (_a) {
        var isSelected = _a.isSelected, rowId = _a.rowId;
        var currRow = rows === null || rows === void 0 ? void 0 : rows[rowId];
        if (currRow) {
            onSelect(isSelected ? __spreadArray(__spreadArray([], selected, true), [currRow], false) : selected.filter(function (_a) {
                var id = _a.id;
                return id !== currRow.id;
            }));
        }
    };
    return (React.createElement(Fragment, null,
        onUpdateData && (React.createElement(PrimaryToolbar, __assign({}, (onSelect &&
            pagination && {
            bulkSelect: __assign({ count: selected === null || selected === void 0 ? void 0 : selected.length, onSelect: function (isSelected) {
                    if (isSelected) {
                        onSelect(unique === null || unique === void 0 ? void 0 : unique(__spreadArray(__spreadArray([], rows, true), selected, true)));
                    }
                    else {
                        onSelect(selected.filter(function (_a) {
                            var id = _a.id;
                            return !rows.find(function (_a) {
                                var rowId = _a.id;
                                return rowId === id;
                            });
                        }));
                    }
                }, checked: loaded && (calculateChecked === null || calculateChecked === void 0 ? void 0 : calculateChecked(rows, selected)), items: [
                    {
                        title: 'Select none (0)',
                        onClick: function () { return onSelect([]); },
                    },
                    __assign({}, (loaded && (rows === null || rows === void 0 ? void 0 : rows.length) > 0
                        ? {
                            title: "Select page (".concat(rows.length, ")"),
                            onClick: function () { return onSelect(unique(__spreadArray(__spreadArray([], rows, true), selected, true))); },
                        }
                        : {})),
                ] }, (bulkSelect || {})),
        }), (filters && {
            filterConfig: {
                items: filters,
            },
        }), { pagination: loaded ? (__assign(__assign({}, (pagination || {})), { itemCount: pagination === null || pagination === void 0 ? void 0 : pagination.count, onSetPage: function (_e, page) { return onUpdateData(__assign(__assign({}, pagination), { page: page })); }, onPerPageSelect: function (_e, perPage) { return onUpdateData(__assign(__assign({}, pagination), { page: 1, perPage: perPage })); } })) : (React.createElement(Skeleton, { size: "lg" })) }, primaryToolbarProps))),
        children,
        loaded ? (React.createElement(Table, __assign({ "aria-label": title || "".concat(systemName, " ").concat(entityName), variant: "compact", className: "ins-c-tag-modal__table", cells: columns, rows: (rows === null || rows === void 0 ? void 0 : rows.length)
                ? rows
                : [
                    {
                        cells: [
                            {
                                title: (React.createElement(EmptyTable, null,
                                    React.createElement(Bullseye, null,
                                        React.createElement(EmptyState, { variant: EmptyStateVariant.full },
                                            React.createElement(Title, { headingLevel: "h5", size: "lg" },
                                                "No ",
                                                entityName,
                                                " found"),
                                            React.createElement(EmptyStateBody, null,
                                                "This filter criteria matches no ",
                                                entityName,
                                                ". ",
                                                React.createElement("br", null),
                                                " Try changing your filter settings."))))),
                                props: {
                                    colSpan: columns.length,
                                },
                            },
                        ],
                    },
                ] }, (onSelect &&
            (rows === null || rows === void 0 ? void 0 : rows.length) && {
            onSelect: function (_event, isSelected, rowId) { return onRowSelect({ isSelected: isSelected, rowId: rowId }); },
        }), tableProps),
            React.createElement(TableHeader, null),
            React.createElement(TableBody, null))) : (React.createElement(SkeletonTable, { columns: columns, rowSize: (pagination === null || pagination === void 0 ? void 0 : pagination.perPage) || 10 })),
        onUpdateData && pagination && loaded && (React.createElement(TableToolbar, { isFooter: true, className: "ins-c-inventory__table--toolbar" },
            React.createElement(Pagination, { itemCount: pagination === null || pagination === void 0 ? void 0 : pagination.count, perPage: pagination === null || pagination === void 0 ? void 0 : pagination.perPage, page: (pagination === null || pagination === void 0 ? void 0 : pagination.page) || 0, variant: "bottom", onSetPage: function (_event, page) { return onUpdateData(__assign(__assign({}, pagination), { page: page })); }, onPerPageSelect: function (_event, perPage) { return onUpdateData(__assign(__assign({}, pagination), { page: 1, perPage: perPage })); } })))));
};
TableWithFilter.propTypes = {
    entityName: PropTypes.string,
    loaded: PropTypes.bool,
    systemName: PropTypes.string,
    rows: PropTypes.array,
    selected: PropTypes.array,
    columns: PropTypes.array,
    filters: PropTypes.array,
    pagination: PropTypes.shape({
        count: PropTypes.number,
        page: PropTypes.number,
        perPage: PropTypes.number,
    }),
    primaryToolbarProps: PropTypes.object,
    tableProps: PropTypes.object,
    children: PropTypes.node,
    title: PropTypes.node,
    calculateChecked: PropTypes.func,
    unique: PropTypes.func,
    onSelect: PropTypes.func,
    onUpdateData: PropTypes.func,
    bulkSelect: PropTypes.any,
};
TableWithFilter.defaultProps = {
    entityName: 'tags',
};
export default TableWithFilter;
//# sourceMappingURL=TableWithFilter.js.map