"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _reactCore = require("@scalprum/react-core");

var _Bullseye = require("@patternfly/react-core/dist/js/layouts/Bullseye/Bullseye.js");

var _Spinner = require("@patternfly/react-core/dist/js/components/Spinner/Spinner.js");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var BaseAsyncComponent = function BaseAsyncComponent(_ref) {
  var appName = _ref.appName,
      scope = _ref.scope,
      module = _ref.module,
      fallback = _ref.fallback,
      innerRef = _ref.innerRef,
      props = (0, _objectWithoutProperties2["default"])(_ref, ["appName", "scope", "module", "fallback", "innerRef"]);
  return /*#__PURE__*/_react["default"].createElement(_react.Suspense, {
    fallback: fallback
  }, /*#__PURE__*/_react["default"].createElement(_reactCore.ScalprumComponent, (0, _extends2["default"])({
    appName: appName,
    module: module,
    scope: scope || appName,
    ErrorComponent: fallback,
    ref: innerRef
  }, props)));
};
/**
 * Async component that wraps ScalprumComponent for easier manipulation.
 *
 * This component uses fallback as ErrorComponent, if you want to show different
 * component for error pass it as ErrorComponent prop.
 */


var AsynComponent = /*#__PURE__*/_react["default"].forwardRef(function (props, ref) {
  return /*#__PURE__*/_react["default"].createElement(BaseAsyncComponent, (0, _extends2["default"])({
    innerRef: ref
  }, props));
});

AsynComponent.propTypes = {
  /** React Suspense fallback component. <a href="https://reactjs.org/docs/code-splitting.html#reactlazy" target="_blank">Learn more</a>. */
  fallback: _propTypes["default"].node,

  /** Name of the app from which module will be loaded. */
  appName: _propTypes["default"].string.isRequired,

  /** Loaded module, it has to start with `./`. */
  module: _propTypes["default"].string.isRequired,

  /** Optional scope, if not passed appName is used. */
  scope: _propTypes["default"].string
};
AsynComponent.defaultProps = {
  fallback: /*#__PURE__*/_react["default"].createElement(_Bullseye.Bullseye, null, /*#__PURE__*/_react["default"].createElement(_Spinner.Spinner, {
    size: "xl"
  }))
};
BaseAsyncComponent.propTypes = _objectSpread(_objectSpread({}, AsynComponent.propTypes), {}, {
  innerRef: _propTypes["default"].any
});
var _default = AsynComponent;
exports["default"] = _default;