"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = _interopRequireWildcard(require("react"));

var _Checkbox = require("@patternfly/react-core/dist/js/components/Checkbox/Checkbox.js");

var _Radio = require("@patternfly/react-core/dist/js/components/Radio/Radio.js");

var _propTypes = _interopRequireDefault(require("prop-types"));

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var FilterInput = /*#__PURE__*/function (_Component) {
  (0, _inherits2["default"])(FilterInput, _Component);

  var _super = _createSuper(FilterInput);

  function FilterInput() {
    var _this;

    (0, _classCallCheck2["default"])(this, FilterInput);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "state", {
      checked: false
    });
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "handleChange", function (checked) {
      var _this$props = _this.props,
          type = _this$props.type,
          addRemoveFilters = _this$props.addRemoveFilters,
          param = _this$props.param,
          value = _this$props.value;
      var updateState;

      switch (type) {
        case 'checkbox':
          updateState = {
            checked: !_this.state.checked
          };
          break;
      }

      _this.setState(_objectSpread({}, updateState));

      addRemoveFilters(value, param, type, checked);
    });
    return _this;
  }

  (0, _createClass2["default"])(FilterInput, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this$props2 = this.props,
          type = _this$props2.type,
          filters = _this$props2.filters,
          param = _this$props2.param,
          value = _this$props2.value;

      switch (type) {
        case 'checkbox':
          param in filters && filters[param] && filters[param].includes(value) ? this.setState({
            checked: true
          }) : this.setState({
            checked: false
          });
          break;
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props3 = this.props,
          label = _this$props3.label,
          id = _this$props3.id,
          param = _this$props3.param,
          value = _this$props3.value,
          type = _this$props3.type,
          filters = _this$props3.filters;
      var checked = this.state.checked;
      return function () {
        switch (type) {
          case 'checkbox':
            return /*#__PURE__*/_react["default"].createElement(_Checkbox.Checkbox, {
              "aria-label": label,
              id: id,
              isChecked: checked,
              label: label,
              onChange: _this2.handleChange,
              param: param,
              value: value
            });

          case 'radio':
            return /*#__PURE__*/_react["default"].createElement(_Radio.Radio, {
              isChecked: filters[param] === value,
              "aria-label": label,
              id: id,
              label: label,
              name: param,
              onChange: _this2.handleChange,
              param: param,
              value: value
            });
        }
      }();
    }
  }]);
  return FilterInput;
}(_react.Component);

FilterInput.propTypes = {
  addRemoveFilters: _propTypes["default"].func,
  className: _propTypes["default"].string,
  currentPage: _propTypes["default"].string,
  id: _propTypes["default"].string.isRequired,
  label: _propTypes["default"].node.isRequired,
  param: _propTypes["default"].string,
  value: _propTypes["default"].any,
  filters: _propTypes["default"].object,
  type: _propTypes["default"].string
};
FilterInput.defaultProps = {
  addRemoveFilters: Function.prototype,
  className: null,
  currentPage: null,
  param: null,
  filters: {},
  type: 'checkbox',
  value: undefined
};
var _default = FilterInput;
exports["default"] = _default;