"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _reactCore = require("@scalprum/react-core");

var _reactRouterDom = require("react-router-dom");

var _reactRedux = require("react-redux");

var _Bullseye = require("@patternfly/react-core/dist/js/layouts/Bullseye/Bullseye.js");

var _Spinner = require("@patternfly/react-core/dist/js/components/Spinner/Spinner.js");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || (0, _typeof2["default"])(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

var AsyncInventory = /*#__PURE__*/_react["default"].lazy(function () {
  return Promise.resolve().then(function () {
    return _interopRequireWildcard(require('./AsyncInventory'));
  });
});

var BaseDetailWrapper = function BaseDetailWrapper(props) {
  var history = (0, _reactRouterDom.useHistory)();
  var store = (0, _reactRedux.useStore)();
  return /*#__PURE__*/_react["default"].createElement(_react.Suspense, {
    fallback: props.fallback
  }, /*#__PURE__*/_react["default"].createElement(_reactCore.ScalprumComponent, (0, _extends2["default"])({
    history: history,
    store: store,
    appName: "chrome",
    module: "./DetailWrapper",
    scope: "chrome",
    ErrorComponent: /*#__PURE__*/_react["default"].createElement(AsyncInventory, (0, _extends2["default"])({
      component: "DetailWrapper"
    }, props)),
    ref: props.innerRef
  }, props)));
};

BaseDetailWrapper.propTypes = {
  fallback: _propTypes["default"].node,
  innerRef: _propTypes["default"].object
};
/**
 * Inventory sub component.
 *
 * This component wraps entire system detail in order to show loading state and drawer (if enabled).
 */

var DetailWrapper = /*#__PURE__*/_react["default"].forwardRef(function (props, ref) {
  return /*#__PURE__*/_react["default"].createElement(BaseDetailWrapper, (0, _extends2["default"])({
    innerRef: ref
  }, props));
});

DetailWrapper.propTypes = {
  /** React Suspense fallback component. <a href="https://reactjs.org/docs/code-splitting.html#reactlazy" target="_blank">Learn more</a>. */
  fallback: _propTypes["default"].node
};
DetailWrapper.defaultProps = {
  fallback: /*#__PURE__*/_react["default"].createElement(_Bullseye.Bullseye, {
    className: "pf-u-p-lg"
  }, /*#__PURE__*/_react["default"].createElement(_Spinner.Spinner, {
    size: "xl"
  }))
};
var _default = DetailWrapper;
exports["default"] = _default;