import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _assertThisInitialized from "@babel/runtime/helpers/assertThisInitialized";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _defineProperty from "@babel/runtime/helpers/defineProperty";

var _PropTypes$shape4;

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

import React, { Component, Fragment } from 'react';
import PropTypes from 'prop-types';
import { Select } from "@patternfly/react-core/dist/esm/components/Select/Select.js";
import { SelectOption } from "@patternfly/react-core/dist/esm/components/Select/SelectOption.js";
import { SelectVariant } from "@patternfly/react-core/dist/esm/components/Select/selectConstants.js";
import { SelectGroup } from "@patternfly/react-core/dist/esm/components/Select/SelectGroup.js";
import { Radio } from "@patternfly/react-core/dist/esm/components/Radio/Radio.js";
import { Checkbox } from "@patternfly/react-core/dist/esm/components/Checkbox/Checkbox.js";
import { Button } from "@patternfly/react-core/dist/esm/components/Button/Button.js";
import Text from './TextFilter';
import isEqual from 'lodash/isEqual';
export var groupType = {
  checkbox: 'checkbox',
  radio: 'radio',
  button: 'button',
  plain: 'plain'
};

var Group = /*#__PURE__*/function (_Component) {
  _inherits(Group, _Component);

  var _super = _createSuper(Group);

  function Group() {
    var _this;

    _classCallCheck(this, Group);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    _defineProperty(_assertThisInitialized(_this), "state", {
      isExpanded: false,
      selected: {},
      filterBy: ''
    });

    _defineProperty(_assertThisInitialized(_this), "onToggle", function (isExpanded) {
      _this.setState({
        isExpanded: isExpanded
      });
    });

    _defineProperty(_assertThisInitialized(_this), "mapItems", function (_ref, groupKey) {
      var groupValue = _ref.groupValue,
          onSelect = _ref.onSelect,
          groupLabel = _ref.groupLabel,
          groupId = _ref.groupId,
          type = _ref.type,
          variant = _ref.variant,
          items = _ref.items,
          group = _objectWithoutProperties(_ref, ["groupValue", "onSelect", "groupLabel", "groupId", "type", "variant", "items"]);

      var onFilter = _this.props.onFilter;
      var filterBy = _this.state.filterBy;
      var input;

      try {
        input = new RegExp(filterBy, 'i');
      } catch (err) {
        input = new RegExp(filterBy.replace(/[.*+?^${}()|[\]\\]/g, '\\$&'), 'i');
      }

      return items.filter(function (item) {
        return onFilter || groupValue && input.test(groupValue) || groupLabel && input.test(groupLabel) || item.value && input.test(item.value) || item.label && input.test(item.label);
      }).map(function (_ref2, key) {
        var value = _ref2.value,
            isChecked = _ref2.isChecked,
            _onClick = _ref2.onClick,
            label = _ref2.label,
            itemProps = _ref2.props,
            id = _ref2.id,
            item = _objectWithoutProperties(_ref2, ["value", "isChecked", "onClick", "label", "props", "id"]);

        return /*#__PURE__*/React.createElement(SelectOption, _extends({}, item, {
          label: groupLabel || '',
          key: id || key,
          value: String(value || id || key || ''),
          onClick: function onClick(e) {
            var _this2;

            if (e.target.tagName !== 'INPUT') {
              e.preventDefault();
              e.stopPropagation();
            }

            var clickedGroup = _objectSpread({
              value: groupValue,
              label: groupLabel,
              id: groupId,
              type: type,
              items: items
            }, group);

            var clickedItem = _objectSpread({
              value: value,
              label: label,
              id: id,
              type: type
            }, item);

            var props = [e, clickedGroup, clickedItem, groupValue || groupKey, value || key];

            (_this2 = _this).onSelect.apply(_this2, props);

            onSelect && onSelect.apply(void 0, props);
            _onClick && _onClick.apply(void 0, props);
          }
        }), type === groupType.checkbox ? /*#__PURE__*/React.createElement(Checkbox, _extends({}, itemProps, {
          label: label,
          isChecked: isChecked || _this.isChecked(groupValue || groupKey, value || key, id, item === null || item === void 0 ? void 0 : item.tagValue) || false,
          onChange: function onChange(value, event) {
            item.onChange && item.onChange(value, event);
          },
          name: item.name || value || "".concat(groupKey, "-").concat(key),
          id: id || value || "".concat(groupKey, "-").concat(key)
        })) : type === groupType.radio ? /*#__PURE__*/React.createElement(Radio, {
          isChecked: isChecked || _this.isChecked(groupValue || groupKey, value || key, id, item === null || item === void 0 ? void 0 : item.tagValue) || false,
          onChange: function onChange(value, event) {
            item.onChange && item.onChange(value, event);
          },
          value: value || key,
          name: item.name || value || "".concat(groupKey, "-").concat(key),
          label: label,
          id: id || value || "".concat(groupKey, "-").concat(key)
        }) : type === groupType.button ? /*#__PURE__*/React.createElement(Button, _extends({}, itemProps, {
          className: "pf-c-select__option-button ".concat((itemProps === null || itemProps === void 0 ? void 0 : itemProps.className) || ''),
          variant: variant,
          onClick: item.onClick
        }), label) : [// we have to wrap it in array, otherwise PF will complain
        type !== groupType.checkbox && type !== groupType.radio ? label : '']);
      });
    });

    _defineProperty(_assertThisInitialized(_this), "calculateSelected", function (_ref3, groupKey, itemKey) {
      var type = _ref3.type;
      var selected = _this.state.selected;
      var propSelected = _this.props.selected;
      var activeGroup = selected[groupKey] || propSelected[groupKey];

      if (activeGroup) {
        if (type !== groupType.radio && (activeGroup[itemKey] instanceof Object ? activeGroup[itemKey].isSelected : Boolean(activeGroup[itemKey]))) {
          return _objectSpread(_objectSpread(_objectSpread({}, propSelected), selected), {}, _defineProperty({}, groupKey, _objectSpread(_objectSpread({}, activeGroup || {}), {}, _defineProperty({}, itemKey, false))));
        }

        return _objectSpread(_objectSpread(_objectSpread({}, propSelected), selected), {}, _defineProperty({}, groupKey, _objectSpread(_objectSpread({}, type !== groupType.radio ? activeGroup || {} : {}), {}, _defineProperty({}, itemKey, true))));
      }

      return _objectSpread(_objectSpread(_objectSpread({}, propSelected), selected), {}, _defineProperty({}, groupKey, _defineProperty({}, itemKey, true)));
    });

    _defineProperty(_assertThisInitialized(_this), "setNewSelection", function (onChange, event, newSelection, group, item, groupKey, itemKey) {
      if (onChange) {
        if (group) {
          onChange(event, newSelection, group, item, groupKey, itemKey);
        } else {
          onChange(event, newSelection);
        }

        _this.setState({
          selected: {}
        });
      }

      _this.setState({
        selected: newSelection
      });
    });

    _defineProperty(_assertThisInitialized(_this), "onSelect", function (event, group, item, groupKey, itemKey) {
      var newSelection = _this.calculateSelected(group, groupKey, itemKey);

      var onChange = _this.props.onChange;

      _this.setNewSelection(onChange, event, newSelection, group, item, groupKey, itemKey);
    });

    _defineProperty(_assertThisInitialized(_this), "onGroupSelect", function (event, groupValue, items) {
      var onChange = _this.props.onChange;
      var currentSelection = _this.state.selected;
      var allSelected = Object.values(currentSelection[groupValue] || {}).filter(function (value) {
        return value === true;
      }).length === items.length;
      var newSelection = allSelected ? {} : _objectSpread(_objectSpread({}, currentSelection), {}, _defineProperty({}, groupValue, items.reduce(function (selection, currentItem) {
        return _objectSpread(_objectSpread({}, selection), {}, _defineProperty({}, currentItem.value, true));
      }, {})));

      _this.setNewSelection(onChange, event, newSelection);
    });

    _defineProperty(_assertThisInitialized(_this), "isGroupChecked", function (groupValue, items) {
      var stateSelected = _this.state.selected;
      var propSelected = _this.props.selected;

      var selected = _objectSpread(_objectSpread({}, propSelected), stateSelected);

      var selectedGroupValues = Object.values(selected[groupValue] || {}).filter(function (value) {
        return value === true;
      });
      var groupSelected = selectedGroupValues.length > 0 ? selectedGroupValues.length === items.length ? true : null : false;
      return groupSelected;
    });

    _defineProperty(_assertThisInitialized(_this), "isChecked", function (groupValue, itemValue, id, tagValue) {
      var stateSelected = _this.state.selected;
      var propSelected = _this.props.selected;

      var selected = _objectSpread(_objectSpread({}, propSelected), stateSelected);

      if (typeof selected[groupValue] === 'undefined') {
        return false;
      }

      if (selected[groupValue][itemValue] instanceof Object) {
        if (selected[groupValue][itemValue].isSelected) {
          var _selected$groupValue$, _selected$groupValue$2, _selected$groupValue$5, _selected$groupValue$6;

          if ((_selected$groupValue$ = selected[groupValue][itemValue]) !== null && _selected$groupValue$ !== void 0 && (_selected$groupValue$2 = _selected$groupValue$.item) !== null && _selected$groupValue$2 !== void 0 && _selected$groupValue$2.id) {
            var _selected$groupValue$3, _selected$groupValue$4;

            return id === ((_selected$groupValue$3 = selected[groupValue][itemValue]) === null || _selected$groupValue$3 === void 0 ? void 0 : (_selected$groupValue$4 = _selected$groupValue$3.item) === null || _selected$groupValue$4 === void 0 ? void 0 : _selected$groupValue$4.id);
          } else if ((_selected$groupValue$5 = selected[groupValue][itemValue]) !== null && _selected$groupValue$5 !== void 0 && (_selected$groupValue$6 = _selected$groupValue$5.item) !== null && _selected$groupValue$6 !== void 0 && _selected$groupValue$6.tagValue) {
            var _selected$groupValue$7, _selected$groupValue$8;

            return tagValue === ((_selected$groupValue$7 = selected[groupValue][itemValue]) === null || _selected$groupValue$7 === void 0 ? void 0 : (_selected$groupValue$8 = _selected$groupValue$7.item) === null || _selected$groupValue$8 === void 0 ? void 0 : _selected$groupValue$8.tagValue);
          }
        }

        return selected[groupValue][itemValue].isSelected;
      }

      return Boolean(selected[groupValue][itemValue]);
    });

    _defineProperty(_assertThisInitialized(_this), "customFilter", function (e) {
      var onFilter = _this.props.onFilter;
      var value = e.target.value;

      _this.setState({
        filterBy: value
      }, function () {
        onFilter && onFilter(value);
      });
    });

    _defineProperty(_assertThisInitialized(_this), "clearSelection", function () {
      var onFilter = _this.props.onFilter;
      onFilter && onFilter('');

      _this.setState({
        filterBy: '',
        isExpanded: false
      });
    });

    return _this;
  }

  _createClass(Group, [{
    key: "componentDidUpdate",
    value: function componentDidUpdate(_ref4) {
      var prevSelected = _ref4.selected,
          prevFilterBy = _ref4.filterBy;
      var _this$props = this.props,
          selected = _this$props.selected,
          filterBy = _this$props.filterBy;

      if (!isEqual(prevSelected, selected)) {
        this.setState({
          selected: selected
        });
      }

      if (filterBy !== undefined && prevFilterBy !== filterBy) {
        this.setState({
          filterBy: filterBy
        });
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this3 = this;

      var _this$state = this.state,
          isExpanded = _this$state.isExpanded,
          filterBy = _this$state.filterBy;
      var _this$props2 = this.props,
          groups = _this$props2.groups,
          items = _this$props2.items,
          placeholder = _this$props2.placeholder,
          className = _this$props2.className,
          selected = _this$props2.selected,
          isFilterable = _this$props2.isFilterable,
          isDisabled = _this$props2.isDisabled,
          onFilter = _this$props2.onFilter,
          onShowMore = _this$props2.onShowMore,
          showMoreTitle = _this$props2.showMoreTitle,
          showMoreOptions = _this$props2.showMoreOptions;
      var filterItems = items || groups;
      var showMore = {
        type: groupType.button,
        variant: (showMoreOptions === null || showMoreOptions === void 0 ? void 0 : showMoreOptions.variant) || 'link',
        items: [_objectSpread(_objectSpread({}, showMoreOptions), {}, {
          label: showMoreTitle,
          type: groupType.button,
          onClick: function onClick(e) {
            return onShowMore(e, function () {
              return _this3.setState({
                isExpanded: false
              });
            });
          }
        })]
      };
      return /*#__PURE__*/React.createElement(Fragment, null, !filterItems || filterItems && filterItems.length <= 0 ? /*#__PURE__*/React.createElement(Text, _extends({}, this.props, {
        value: "".concat(selected)
      })) : /*#__PURE__*/React.createElement(Select, _extends({
        className: className,
        variant: isFilterable || onFilter ? SelectVariant.typeahead : SelectVariant.single,
        "aria-label": "Select Input",
        onToggle: this.onToggle,
        isOpen: isExpanded,
        isDisabled: isDisabled,
        onSelect: function onSelect() {
          return undefined;
        },
        placeholderText: placeholder,
        onClear: this.clearSelection,
        selections: filterBy === '' ? null : filterBy
      }, (isFilterable || onFilter) && {
        onFilter: function onFilter(e) {
          return e && _this3.customFilter(e);
        }
      }, groups && groups.length > 0 && {
        isGrouped: true
      }), /*#__PURE__*/React.createElement("div", {
        className: "ins-c-select__scrollable-section",
        value: ""
      }, groups && groups.length > 0 ? groups.map(function (_ref5, groupKey) {
        var groupValue = _ref5.value,
            onSelect = _ref5.onSelect,
            groupSelectable = _ref5.groupSelectable,
            groupLabel = _ref5.label,
            groupId = _ref5.id,
            type = _ref5.type,
            items = _ref5.items,
            group = _objectWithoutProperties(_ref5, ["value", "onSelect", "groupSelectable", "label", "id", "type", "items"]);

        var filteredItems = _this3.mapItems(_objectSpread({
          groupValue: groupValue,
          onSelect: onSelect,
          groupLabel: groupLabel,
          groupId: groupId,
          groupSelectable: groupSelectable,
          type: type,
          items: items
        }, group), groupKey).filter(Boolean);

        return (
          /*#__PURE__*/

          /**
           * DO NOT DELET THE EMPTY VALUE ON THE DIV ELEMENT
           * If we delete it, it breaks the select filtering
           * Here is the code that creates the runtime crash:
           * https://github.com/patternfly/patternfly-react/blob/master/packages/react-core/src/components/Select/Select.tsx#L615
           */
          React.createElement("div", {
            key: groupId || groupValue || groupKey,
            value: ""
          }, groupSelectable && /*#__PURE__*/React.createElement(SelectOption, {
            onClick: function onClick(event) {
              _this3.onGroupSelect(event, groupValue || groupKey, items);
            }
          }, /*#__PURE__*/React.createElement(Checkbox, {
            isChecked: _this3.isGroupChecked(groupValue || groupKey, items),
            label: groupLabel
          })), /*#__PURE__*/React.createElement(SelectGroup, _extends({}, group, {
            className: "pf-u-pl-sm",
            label: !groupSelectable && groupLabel,
            value: groupId || groupValue || groupKey,
            id: groupId || "group-".concat(groupValue || groupKey)
          }), filteredItems))
        );
      }) : this.mapItems({
        items: items
      })), onShowMore ? /*#__PURE__*/React.createElement(SelectGroup, {
        value: ""
      }, /*#__PURE__*/React.createElement(Button, _extends({}, showMore.items[0], {
        className: "pf-c-select__menu-item",
        variant: showMore.variant,
        onClick: showMore.items[0].onClick,
        value: "Show more"
      }), showMore.items[0].label)) : /*#__PURE__*/React.createElement("span", {
        hidden: true,
        value: ""
      })));
    }
  }]);

  return Group;
}(Component);

var itemsProps = PropTypes.arrayOf(PropTypes.shape({
  value: PropTypes.string,
  label: PropTypes.node,
  id: PropTypes.string,
  isChecked: PropTypes.bool,
  onClick: PropTypes.func,
  props: PropTypes.shape(_defineProperty({}, PropTypes.string, PropTypes.any))
}));
Group.propTypes = {
  selected: PropTypes.shape(_defineProperty({}, PropTypes.string, PropTypes.shape(_defineProperty({}, PropTypes.string, PropTypes.oneOfType([PropTypes.bool, PropTypes.shape({
    isSelected: PropTypes.bool
  })]))))),
  onChange: PropTypes.func,
  groups: PropTypes.arrayOf(PropTypes.shape({
    label: PropTypes.node,
    value: PropTypes.string,
    onSelect: PropTypes.func,
    type: PropTypes.oneOf(Object.values(groupType)),
    items: itemsProps
  })),
  filterBy: PropTypes.string,
  items: itemsProps,
  isFilterable: PropTypes.bool,
  onFilter: PropTypes.func,
  onShowMore: PropTypes.func,
  showMoreTitle: PropTypes.string,
  isDisabled: PropTypes.bool,
  showMoreOptions: PropTypes.shape((_PropTypes$shape4 = {
    variant: PropTypes.string
  }, _defineProperty(_PropTypes$shape4, PropTypes.string, PropTypes.oneOfType([PropTypes.string, PropTypes.number])), _defineProperty(_PropTypes$shape4, "props", _defineProperty({}, PropTypes.string, PropTypes.oneOfType([PropTypes.string, PropTypes.number]))), _PropTypes$shape4)),
  placeholder: PropTypes.node,
  className: PropTypes.string
};
Group.defaultProps = {
  selected: {},
  filterBy: '',
  onChange: function onChange() {
    return undefined;
  },
  showMoreTitle: 'Show more',
  groups: [],
  isFilterable: false,
  isDisabled: false
};
export default Group;