import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import React from 'react';
import PropTypes from 'prop-types';
import { Title } from "@patternfly/react-core/dist/esm/components/Title/Title.js";
import { Button } from "@patternfly/react-core/dist/esm/components/Button/Button.js";
import { EmptyState } from "@patternfly/react-core/dist/esm/components/EmptyState/EmptyState.js";
import { EmptyStateVariant } from "@patternfly/react-core/dist/esm/components/EmptyState/EmptyState.js";
import { EmptyStateIcon } from "@patternfly/react-core/dist/esm/components/EmptyState/EmptyStateIcon.js";
import { EmptyStateBody } from "@patternfly/react-core/dist/esm/components/EmptyState/EmptyStateBody.js";
import LockIcon from "@patternfly/react-icons/dist/esm/icons/lock-icon";
import "../../NotAuthorized/./NotAuthorized.css";

var ContactBody = function ContactBody() {
  return /*#__PURE__*/React.createElement(React.Fragment, null, "Contact your organization administrator(s) for more information or visit\xA0", /*#__PURE__*/React.createElement("a", {
    href: "./settings/my-user-access"
  }, "My User Access"), "\xA0 to learn more about your permissions.");
};

var NotAuthorized = function NotAuthorized(_ref) {
  var prevPageButtonText = _ref.prevPageButtonText,
      toLandingPageText = _ref.toLandingPageText,
      title = _ref.title,
      actions = _ref.actions,
      serviceName = _ref.serviceName,
      Icon = _ref.icon,
      description = _ref.description,
      showReturnButton = _ref.showReturnButton,
      className = _ref.className,
      props = _objectWithoutProperties(_ref, ["prevPageButtonText", "toLandingPageText", "title", "actions", "serviceName", "icon", "description", "showReturnButton", "className"]);

  var heading = title || "You do not have access to ".concat(serviceName);
  return /*#__PURE__*/React.createElement(EmptyState, _extends({
    variant: EmptyStateVariant.full,
    className: "ins-c-not-authorized ".concat(className || '')
  }, props), /*#__PURE__*/React.createElement(EmptyStateIcon, {
    icon: Icon
  }), /*#__PURE__*/React.createElement(Title, {
    headingLevel: "h5",
    size: "lg"
  }, heading), /*#__PURE__*/React.createElement(EmptyStateBody, null, description), actions, showReturnButton && (document.referrer ? /*#__PURE__*/React.createElement(Button, {
    variant: "primary",
    onClick: function onClick() {
      return history.back();
    }
  }, prevPageButtonText) : /*#__PURE__*/React.createElement(Button, {
    variant: "primary",
    component: "a",
    href: "."
  }, toLandingPageText)));
};

var serviceNamePropType = function serviceNamePropType(props, propName, componentName) {
  if (typeof props.title === 'undefined') {
    var _PropTypes$node;

    for (var _len = arguments.length, args = new Array(_len > 3 ? _len - 3 : 0), _key = 3; _key < _len; _key++) {
      args[_key - 3] = arguments[_key];
    }

    return (_PropTypes$node = PropTypes.node).isRequired.apply(_PropTypes$node, [props, propName, componentName].concat(args));
  }
};

NotAuthorized.propTypes = {
  serviceName: serviceNamePropType,
  icon: PropTypes.func,
  description: PropTypes.node,
  showReturnButton: PropTypes.bool,
  className: PropTypes.string,
  title: PropTypes.node,
  actions: PropTypes.oneOfType([PropTypes.node, PropTypes.arrayOf(PropTypes.node)]),
  prevPageButtonText: PropTypes.node,
  toLandingPageText: PropTypes.node
};
NotAuthorized.defaultProps = {
  icon: LockIcon,
  showReturnButton: true,
  description: /*#__PURE__*/React.createElement(ContactBody, null),
  actions: null,
  prevPageButtonText: 'Return to previous page',
  toLandingPageText: 'Go to landing page'
};
export default NotAuthorized;