import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _assertThisInitialized from "@babel/runtime/helpers/assertThisInitialized";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _defineProperty from "@babel/runtime/helpers/defineProperty";

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

import React from 'react';
import PropTypes from 'prop-types';
import { Button } from "@patternfly/react-core/dist/esm/components/Button/Button.js";
import ThumbsUpIcon from "@patternfly/react-icons/dist/esm/icons/thumbs-up-icon";
import OutlinedThumbsUpIcon from "@patternfly/react-icons/dist/esm/icons/outlined-thumbs-up-icon";
import ThumbsDownIcon from "@patternfly/react-icons/dist/esm/icons/thumbs-down-icon";
import OutlinedThumbsDownIcon from "@patternfly/react-icons/dist/esm/icons/outlined-thumbs-down-icon";
export var feedback = {
  negative: -1,
  neutral: 0,
  positive: 1
}; // ruleId - is id of current rule
// onFeedbackSent(ruleId, vote) is a callback which is called when feedback is changed
// where ruleId is id of the rule, vote is either -1, 0 or 1

var RuleFeedback = /*#__PURE__*/function (_React$Component) {
  _inherits(RuleFeedback, _React$Component);

  var _super = _createSuper(RuleFeedback);

  function RuleFeedback() {
    var _this;

    _classCallCheck(this, RuleFeedback);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    _defineProperty(_assertThisInitialized(_this), "state", {
      feedbackSaved: false
    });

    _defineProperty(_assertThisInitialized(_this), "handleFeedbackChange", function (vote) {
      var _this$props = _this.props,
          ruleId = _this$props.ruleId,
          userVote = _this$props.userVote,
          onFeedbackChanged = _this$props.onFeedbackChanged;

      if (userVote === vote) {
        onFeedbackChanged(ruleId, feedback.neutral);
      } else {
        _this.setState({
          feedbackSaved: true
        });

        onFeedbackChanged(ruleId, vote);
      }
    });

    return _this;
  }

  _createClass(RuleFeedback, [{
    key: "render",
    value: function render() {
      var _this2 = this;

      var userVote = this.props.userVote;
      return /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement("span", null, "Is this helpful?"), /*#__PURE__*/React.createElement(Button, {
        className: "ins-c-rule__rule-feedback-like-button",
        variant: "plain",
        "aria-label": "Rule is helpful",
        onClick: function onClick() {
          return _this2.handleFeedbackChange(feedback.positive);
        }
      }, userVote === feedback.positive ? /*#__PURE__*/React.createElement(ThumbsUpIcon, {
        color: "var(--pf-global--success-color--100)"
      }) : /*#__PURE__*/React.createElement(OutlinedThumbsUpIcon, null)), /*#__PURE__*/React.createElement(Button, {
        className: "ins-c-rule__rule-feedback-dislike-button",
        variant: "plain",
        "aria-label": "Rule is not helpful",
        onClick: function onClick() {
          return _this2.handleFeedbackChange(feedback.negative);
        }
      }, userVote === feedback.negative ? /*#__PURE__*/React.createElement(ThumbsDownIcon, {
        color: "var(--pf-global--primary-color--100)"
      }) : /*#__PURE__*/React.createElement(OutlinedThumbsDownIcon, null)), this.state.feedbackSaved && 'Thank you for your feedback!');
    }
  }]);

  return RuleFeedback;
}(React.Component);

;
RuleFeedback.propTypes = {
  ruleId: PropTypes.string.isRequired,
  userVote: PropTypes.oneOf(Object.values(feedback)).isRequired,
  onFeedbackChanged: PropTypes.func.isRequired
};
export default RuleFeedback;