import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

import React, { Suspense } from 'react';
import PropTypes from 'prop-types';
import { ScalprumComponent } from '@scalprum/react-core';
import { Bullseye } from "@patternfly/react-core/dist/esm/layouts/Bullseye/Bullseye.js";
import { Spinner } from "@patternfly/react-core/dist/esm/components/Spinner/Spinner.js";

var BaseAsyncComponent = function BaseAsyncComponent(_ref) {
  var appName = _ref.appName,
      scope = _ref.scope,
      module = _ref.module,
      fallback = _ref.fallback,
      innerRef = _ref.innerRef,
      props = _objectWithoutProperties(_ref, ["appName", "scope", "module", "fallback", "innerRef"]);

  return /*#__PURE__*/React.createElement(Suspense, {
    fallback: fallback
  }, /*#__PURE__*/React.createElement(ScalprumComponent, _extends({
    appName: appName,
    module: module,
    scope: scope || appName,
    ErrorComponent: fallback,
    ref: innerRef
  }, props)));
};
/**
 * Async component that wraps ScalprumComponent for easier manipulation.
 *
 * This component uses fallback as ErrorComponent, if you want to show different
 * component for error pass it as ErrorComponent prop.
 */


var AsynComponent = /*#__PURE__*/React.forwardRef(function (props, ref) {
  return /*#__PURE__*/React.createElement(BaseAsyncComponent, _extends({
    innerRef: ref
  }, props));
});
AsynComponent.propTypes = {
  /** React Suspense fallback component. <a href="https://reactjs.org/docs/code-splitting.html#reactlazy" target="_blank">Learn more</a>. */
  fallback: PropTypes.node,

  /** Name of the app from which module will be loaded. */
  appName: PropTypes.string.isRequired,

  /** Loaded module, it has to start with `./`. */
  module: PropTypes.string.isRequired,

  /** Optional scope, if not passed appName is used. */
  scope: PropTypes.string
};
AsynComponent.defaultProps = {
  fallback: /*#__PURE__*/React.createElement(Bullseye, null, /*#__PURE__*/React.createElement(Spinner, {
    size: "xl"
  }))
};
BaseAsyncComponent.propTypes = _objectSpread(_objectSpread({}, AsynComponent.propTypes), {}, {
  innerRef: PropTypes.any
});
export default AsynComponent;