import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _extends from "@babel/runtime/helpers/extends";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _assertThisInitialized from "@babel/runtime/helpers/assertThisInitialized";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _defineProperty from "@babel/runtime/helpers/defineProperty";

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

import React, { Component } from 'react';
import PropTypes from 'prop-types';
import "../../TagModal/./tagModal.css";
import { Modal } from "@patternfly/react-core/dist/esm/components/Modal/Modal.js";
import { Button } from "@patternfly/react-core/dist/esm/components/Button/Button.js";
import { Tabs } from "@patternfly/react-core/dist/esm/components/Tabs/Tabs.js";
import { Tab } from "@patternfly/react-core/dist/esm/components/Tabs/Tab.js";
import { TabTitleText } from "@patternfly/react-core/dist/esm/components/Tabs/TabTitleText.js";
import classNames from 'classnames';
import TableWithFilter from './TableWithFilter';

var calculateChecked = function calculateChecked() {
  var rows = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
  var selected = arguments.length > 1 ? arguments[1] : undefined;
  return rows.every(function (_ref) {
    var id = _ref.id;
    return selected && selected.find(function (_ref2) {
      var selectedId = _ref2.id;
      return selectedId === id;
    });
  }) ? rows.length > 0 : rows.some(function (_ref3) {
    var id = _ref3.id;
    return selected && selected.find(function (_ref4) {
      var selectedId = _ref4.id;
      return selectedId === id;
    });
  }) && null;
};

var unique = function unique(arr) {
  return arr.filter(function (_ref5, index, arr) {
    var id = _ref5.id;
    return arr.findIndex(function (_ref6) {
      var currId = _ref6.id;
      return currId === id;
    }) === index;
  });
};

var TagModal = /*#__PURE__*/function (_Component) {
  _inherits(TagModal, _Component);

  var _super = _createSuper(TagModal);

  function TagModal() {
    var _this;

    _classCallCheck(this, TagModal);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    _defineProperty(_assertThisInitialized(_this), "state", {
      selectedTab: 0
    });

    _defineProperty(_assertThisInitialized(_this), "handleTabClick", function (_event, tabIndex) {
      _this.setState({
        activeTabKey: tabIndex
      });
    });

    _defineProperty(_assertThisInitialized(_this), "renderTable", function (rows, columns, pagination, loaded, filters, selected, onSelect, onUpdateData) {
      return /*#__PURE__*/React.createElement(TableWithFilter, _extends({}, _this.props, {
        rows: rows,
        pagination: pagination,
        loaded: loaded,
        calculateChecked: calculateChecked,
        unique: unique,
        filters: filters,
        title: _this.props.title,
        systemName: _this.props.systemName,
        columns: columns,
        onSelect: onSelect,
        onUpdateData: onUpdateData,
        selected: selected
      }), _this.props.children);
    });

    return _this;
  }

  _createClass(TagModal, [{
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props = this.props,
          className = _this$props.className,
          title = _this$props.title,
          systemName = _this$props.systemName,
          toggleModal = _this$props.toggleModal,
          isOpen = _this$props.isOpen,
          rows = _this$props.rows,
          columns = _this$props.columns,
          children = _this$props.children,
          pagination = _this$props.pagination,
          loaded = _this$props.loaded,
          filters = _this$props.filters,
          onApply = _this$props.onApply,
          tabNames = _this$props.tabNames,
          onSelect = _this$props.onSelect,
          onUpdateData = _this$props.onUpdateData,
          selected = _this$props.selected,
          tableProps = _this$props.tableProps,
          props = _objectWithoutProperties(_this$props, ["className", "title", "systemName", "toggleModal", "isOpen", "rows", "columns", "children", "pagination", "loaded", "filters", "onApply", "tabNames", "onSelect", "onUpdateData", "selected", "tableProps"]);

      var isTabbed = Array.isArray(tabNames);
      return /*#__PURE__*/React.createElement(Modal, _extends({}, props, {
        className: classNames('ins-c-tag-modal', className),
        isOpen: isOpen,
        title: title || "Tags for ".concat(systemName),
        onClose: function onClose(e) {
          return toggleModal(e, false);
        },
        variant: "medium"
      }, onApply && {
        actions: [/*#__PURE__*/React.createElement(Button, {
          key: "confirm",
          variant: "primary",
          isDisabled: isTabbed ? Object.values(selected || {}).every(function (values) {
            return !values || (values === null || values === void 0 ? void 0 : values.length) === 0;
          }) : !selected || (selected === null || selected === void 0 ? void 0 : selected.length) === 0,
          onClick: function onClick(e) {
            onApply();
            toggleModal(e, true);
          }
        }, "Apply ", isTabbed ? 'selected' : 'tags'), /*#__PURE__*/React.createElement(Button, {
          key: "cancel",
          variant: "link",
          onClick: function onClick(e) {
            return toggleModal(e, false);
          }
        }, "Cancel")]
      }), isTabbed ? /*#__PURE__*/React.createElement(Tabs, {
        activeKey: this.state.activeTabKey,
        onSelect: this.handleTabClick
      }, tabNames.map(function (item, key) {
        return /*#__PURE__*/React.createElement(Tab, {
          key: key,
          eventKey: key,
          title: /*#__PURE__*/React.createElement(TabTitleText, null, "All ", item)
        }, _this2.renderTable(rows === null || rows === void 0 ? void 0 : rows[key], columns === null || columns === void 0 ? void 0 : columns[key], pagination === null || pagination === void 0 ? void 0 : pagination[key], loaded === null || loaded === void 0 ? void 0 : loaded[key], filters === null || filters === void 0 ? void 0 : filters[key], selected === null || selected === void 0 ? void 0 : selected[key], onSelect === null || onSelect === void 0 ? void 0 : onSelect[key], onUpdateData === null || onUpdateData === void 0 ? void 0 : onUpdateData[key]));
      })) : this.renderTable(rows, columns, pagination, loaded, filters, selected, onSelect, onUpdateData));
    }
  }]);

  return TagModal;
}(Component);

TagModal.propTypes = {
  tabNames: PropTypes.arrayOf(PropTypes.string),
  loaded: PropTypes.oneOfType([PropTypes.bool, PropTypes.arrayOf(PropTypes.bool)]),
  title: PropTypes.string,
  systemName: PropTypes.string,
  isOpen: PropTypes.bool,
  toggleModal: PropTypes.func,
  rows: PropTypes.array,
  columns: PropTypes.array,
  className: PropTypes.string,
  tableProps: PropTypes.shape(_defineProperty({}, PropTypes.string, PropTypes.any)),
  onSelect: PropTypes.oneOfType([PropTypes.func, PropTypes.arrayOf(PropTypes.func)]),
  onUpdateData: PropTypes.oneOfType([PropTypes.func, PropTypes.arrayOf(PropTypes.func)]),
  pagination: PropTypes.oneOfType([TableWithFilter.propTypes.pagination, PropTypes.arrayOf(TableWithFilter.propTypes.pagination)]),
  primaryToolbarProps: PropTypes.shape(_defineProperty({}, PropTypes.string, PropTypes.any)),
  selected: PropTypes.array,
  children: PropTypes.node,
  filters: PropTypes.any,
  onApply: PropTypes.func
};
TagModal.defaultProps = {
  loaded: false,
  isOpen: false,
  toggleModal: function toggleModal() {
    return undefined;
  },
  columns: [{
    title: 'Name'
  }, {
    title: 'Tag source'
  }],
  onUpdateData: function onUpdateData() {
    return undefined;
  },
  rows: [],
  tableProps: {},
  pagination: {
    count: 10
  }
};
export default TagModal;